/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = Class.getPrimitiveClass("byte");
    private static final long serialVersionUID = -7183698231559129828L;
    private final byte value;

    public byte byteValue() {
        return this.value;
    }

    public static Byte decode(String string) throws NumberFormatException {
        int n = Integer.decode(string);
        if (n < -128 || n > 127) {
            throw new NumberFormatException();
        }
        return new Byte((byte)n);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Byte && ((Byte)object).value == this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public static byte parseByte(String string) throws NumberFormatException {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    public String toString() {
        return Byte.toString(this.value);
    }

    public static String toString(byte by) {
        return Integer.toString(by);
    }

    public static Byte valueOf(String string) throws NumberFormatException {
        return new Byte(Byte.parseByte(string));
    }

    public static Byte valueOf(String string, int n) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, n));
    }

    public int compareTo(Object object) {
        return this.value - ((Byte)object).value;
    }

    public Byte(String string) throws NumberFormatException {
        this.value = Byte.parseByte(string);
    }

    public Byte(byte by) {
        this.value = by;
    }
}

