/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.UID;
import java.util.Hashtable;
import kaffe.rmi.dgc.DGCImpl;
import kaffe.rmi.server.ProtocolConstants;
import kaffe.rmi.server.UnicastConnection;
import kaffe.rmi.server.UnicastServerRef;

public class UnicastServer
implements ProtocolConstants {
    private static Hashtable objects = new Hashtable();
    private static DGCImpl dgc;

    public static void exportObject(UnicastServerRef unicastServerRef) {
        UnicastServer.startDGC();
        objects.put(unicastServerRef.objid, unicastServerRef);
        unicastServerRef.manager.startServer();
    }

    private static synchronized void startDGC() {
        if (dgc == null) {
            try {
                dgc = new DGCImpl();
                ((UnicastServerRef)dgc.getRef()).exportObject(dgc);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public static void dispatch(UnicastConnection unicastConnection) throws Exception {
        switch (unicastConnection.getDataInputStream().readUnsignedByte()) {
            case 80: {
                UnicastServer.incomingMessageCall(unicastConnection);
                break;
            }
            default: {
                throw new Exception("bad method type");
            }
        }
    }

    private static void incomingMessageCall(UnicastConnection unicastConnection) throws IOException {
        Object object;
        ObjectInputStream objectInputStream = unicastConnection.getObjectInputStream();
        ObjID objID = ObjID.read(objectInputStream);
        int n = objectInputStream.readInt();
        long l = objectInputStream.readLong();
        UnicastServerRef unicastServerRef = (UnicastServerRef)objects.get(objID);
        int n2 = 1;
        if (unicastServerRef != null) {
            try {
                object = unicastServerRef.incomingMessageCall(unicastConnection, n, l);
            }
            catch (Exception exception) {
                object = exception;
                n2 = 2;
            }
        } else {
            object = new NoSuchObjectException("");
            n2 = 2;
        }
        unicastConnection.getDataOutputStream().writeByte(81);
        ObjectOutputStream objectOutputStream = unicastConnection.getObjectOutputStream();
        objectOutputStream.writeByte(n2);
        new UID().write(objectOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
    }
}

