/*
 * Decompiled with CFR 0.152.
 */
package kaffe.util;

public class IdentityHashtable {
    private static final int DEFAULTCAPACITY = 101;
    private static final float DEFAULTLOADFACTOR = 0.75f;
    private static final Object removed = new Object();
    private static final Object free = null;
    private transient Object[] keys;
    private transient Object[] elements;
    private transient float loadFactor;
    private int numberOfKeys;
    private transient int rehashLimit;

    public int size() {
        return this.numberOfKeys;
    }

    public boolean isEmpty() {
        return this.numberOfKeys == 0;
    }

    public synchronized boolean contains(Object object) {
        int n = this.elements.length - 1;
        while (n >= 0) {
            if (object.equals(this.elements[n])) {
                return true;
            }
            --n;
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    private int calculateBucket(Object object) {
        return (System.identityHashCode(object) & Integer.MAX_VALUE) % this.keys.length;
    }

    public synchronized Object get(Object object) {
        Object object2;
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        int n3 = n;
        while (n3 < n2) {
            object2 = this.keys[n3];
            if (object == object2) {
                return this.elements[n3];
            }
            if (object2 == free) {
                return null;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            object2 = this.keys[n3];
            if (object == object2) {
                return this.elements[n3];
            }
            if (object2 == free) {
                return null;
            }
            ++n3;
        }
        return null;
    }

    protected synchronized void rehash() {
        int n = this.keys.length * 2;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.elements;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.rehashLimit = (int)(this.loadFactor * (float)n);
        this.numberOfKeys = 0;
        int n2 = objectArray.length - 1;
        while (n2 >= 0) {
            if (objectArray[n2] != free && objectArray[n2] != removed) {
                this.put(objectArray[n2], objectArray2[n2]);
            }
            --n2;
        }
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3;
        if (this.numberOfKeys >= this.rehashLimit) {
            this.rehash();
        }
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            object3 = this.keys[n4];
            if (object == object3) {
                Object object4 = this.elements[n4];
                this.elements[n4] = object2;
                return object4;
            }
            if (object3 == removed) {
                if (n3 == -1) {
                    n3 = n4;
                }
            } else if (object3 == free) {
                if (n3 == -1) {
                    n3 = n4;
                }
                this.keys[n3] = object;
                this.elements[n3] = object2;
                ++this.numberOfKeys;
                return null;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            object3 = this.keys[n4];
            if (object == object3) {
                Object object5 = this.elements[n4];
                this.elements[n4] = object2;
                return object5;
            }
            if (object3 == removed) {
                if (n3 == -1) {
                    n3 = n4;
                }
            } else if (object3 == free) {
                if (n3 == -1) {
                    n3 = n4;
                }
                this.keys[n3] = object;
                this.elements[n3] = object2;
                ++this.numberOfKeys;
                return null;
            }
            ++n4;
        }
        if (n3 != -1) {
            this.keys[n3] = object;
            this.elements[n3] = object2;
            ++this.numberOfKeys;
            return null;
        }
        throw new Error("Inconsistent IdentityHashtable");
    }

    public synchronized Object remove(Object object) {
        Object object2;
        int n = this.calculateBucket(object);
        int n2 = this.keys.length;
        int n3 = n;
        while (n3 < n2) {
            object2 = this.keys[n3];
            if (object == object2) {
                Object object3 = this.elements[n3];
                this.elements[n3] = removed;
                this.keys[n3] = removed;
                --this.numberOfKeys;
                return object3;
            }
            if (object2 == free) {
                return null;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            object2 = this.keys[n3];
            if (object == object2) {
                Object object4 = this.elements[n3];
                this.elements[n3] = removed;
                this.keys[n3] = removed;
                --this.numberOfKeys;
                return object4;
            }
            if (object2 == free) {
                return null;
            }
            ++n3;
        }
        return null;
    }

    public synchronized void clear() {
        int n = this.keys.length - 1;
        while (n >= 0) {
            this.keys[n] = free;
            this.elements[n] = free;
            --n;
        }
        this.numberOfKeys = 0;
    }

    public IdentityHashtable() {
        this(101, 0.75f);
    }

    public IdentityHashtable(int n) {
        this(n, 0.75f);
    }

    public IdentityHashtable(int n, float f) {
        if (n <= 0) {
            throw new Error("Initial capacity is <= 0");
        }
        if ((double)f <= 0.0) {
            throw new Error("Load Factor is <= 0");
        }
        this.loadFactor = f;
        this.keys = new Object[n];
        this.elements = new Object[n];
        this.numberOfKeys = 0;
        this.rehashLimit = (int)(f * (float)n);
    }
}

