/*
 * Decompiled with CFR 0.152.
 */
package kaffe.tools.javap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaP {
    public static void main(String[] stringArray) {
        JavaP javaP = new JavaP();
        if (stringArray.length == 0) {
            JavaP.usage();
            System.exit(1);
        } else {
            int n = 0;
            while (n < stringArray.length) {
                javaP.doClass(stringArray[n]);
                ++n;
            }
        }
    }

    protected void doClass(String string) {
        try {
            int n;
            Class<?>[] classArray;
            Class<?> clazz = Class.forName(string);
            System.out.print(Modifier.toString(clazz.getModifiers()) + ' ' + clazz);
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                System.out.print(" extends " + clazz2.getName());
            }
            if ((classArray = clazz.getInterfaces()).length > 0) {
                System.out.print(" implements ");
                n = 0;
                while (n < classArray.length) {
                    System.out.print(classArray[n].getName());
                    if (n + 1 < classArray.length) {
                        System.out.print(", ");
                    }
                    ++n;
                }
            }
            System.out.println(" {");
            Field[] fieldArray = clazz.getDeclaredFields();
            n = 0;
            while (n < fieldArray.length) {
                if (!Modifier.isPrivate(fieldArray[n].getModifiers()) && !Modifier.isProtected(fieldArray[n].getModifiers())) {
                    System.out.println("\t" + fieldArray[n]);
                }
                ++n;
            }
            Method[] methodArray = clazz.getDeclaredMethods();
            n = 0;
            while (n < methodArray.length) {
                if (!Modifier.isPrivate(methodArray[n].getModifiers()) && !Modifier.isProtected(methodArray[n].getModifiers())) {
                    System.out.println("\t" + methodArray[n]);
                }
                ++n;
            }
            System.out.println("}");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error: Class " + string + " not found!");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private static void usage() {
        System.err.print("usage: javap [-options] classes\nOptions are:\n\t-b *\t\t\tBackwards compatible with javap in JDK 1.1\n\t-c *\t\t\tDisassemble bytecode\n\t-classpath <path> *\tSpecify where to find classes\n\t-help *\t\t\tPrints this usage message\n\t-l *\t\t\tPrints line number information\n\t-public *\t\tShow only public classes & members\n\t-protected *\t\tShow protected/public classes & members\n\t-package *\t\tSHow package/protected/public classes & members\n\t-private *\t\tShow all classes & members\n\t-s *\t\t\tPrint internal type signatures\n\t-verbose *\t\tPrint stack size, locals and arguments\n  * Option not implemented\n");
    }
}

