/*
 * Decompiled with CFR 0.152.
 */
package kaffe.tools.jar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kaffe.tools.jar.XPFile;
import kaffe.tools.jar.XPFileInputStream;
import kaffe.tools.jar.XPFileOutputStream;
import kaffe.util.Base64;

public class Jar {
    static final boolean debug = false;
    String[] argv;
    String manifest = null;
    boolean create_manifest = true;
    String archive = null;
    String[] files;
    String[] absolute_files;
    String[] dir_changes;
    boolean verbose = false;
    boolean compression = true;
    char mode = '\u0000';
    int exitCode = 0;
    final int bufferSize;
    final byte[] buffer = new byte[8192];
    PrintStream vout = System.out;

    public static void main(String[] stringArray) {
        Jar jar = new Jar(stringArray);
        jar.setExitOnError(true);
        try {
            jar.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            jar.exit(2);
        }
    }

    public void start() throws IOException {
        this.processCommandLine();
        this.processJar();
    }

    public void setExitOnError(boolean bl) {
        this.exitCode = bl ? 1 : 0;
    }

    public int getCompletionCode() {
        return this.exitCode;
    }

    void exit(int n) {
        if (this.exitCode != 0) {
            System.out.flush();
            System.err.flush();
            System.exit(n);
        } else {
            this.exitCode = n;
        }
    }

    void processCommandLine() throws IOException {
        if (this.argv.length == 0) {
            this.printUsage();
            this.exit(1);
        }
        String string = this.argv[0];
        int n = 1;
        int n2 = 0;
        if (string.charAt(0) == '-') {
            ++n2;
        }
        while (n2 < string.length()) {
            switch (string.charAt(n2)) {
                case 'c': 
                case 't': 
                case 'u': 
                case 'x': {
                    if (this.mode != '\u0000') {
                        this.printUsage();
                        this.exit(1);
                    }
                    this.mode = string.charAt(n2);
                    break;
                }
                case 'v': {
                    this.verbose = true;
                    break;
                }
                case 'f': {
                    if (this.archive != null || n >= this.argv.length) {
                        this.printUsage();
                        this.exit(1);
                    }
                    this.archive = this.argv[n++];
                    break;
                }
                case 'm': {
                    if (this.manifest != null || n >= this.argv.length || !this.create_manifest) {
                        this.printUsage();
                        this.exit(1);
                    }
                    this.manifest = this.argv[n++];
                    break;
                }
                case '0': {
                    this.compression = false;
                    break;
                }
                case 'M': {
                    if (this.manifest != null) {
                        this.printUsage();
                        this.exit(1);
                    }
                    this.create_manifest = false;
                    break;
                }
                default: {
                    System.out.println("Illegal option: " + string.charAt(n2));
                    this.printUsage();
                    this.exit(1);
                }
            }
            ++n2;
        }
        n2 = n;
        if (this.argv.length - n2 > 0) {
            this.files = new String[this.argv.length - n2];
            int n3 = 0;
            while (n2 < this.argv.length) {
                if (this.argv[n2].equals("-C")) {
                    if (n2 + 2 >= this.argv.length || this.argv[n2 + 1].equals("-C") || this.argv[n2 + 2].equals("-C")) {
                        this.printUsage();
                        this.exit(1);
                    }
                    ++n2;
                    if (this.dir_changes == null) {
                        this.dir_changes = new String[this.files.length];
                    }
                    this.dir_changes[n3] = this.argv[n2];
                    --n3;
                } else {
                    this.files[n3] = this.argv[n2];
                }
                ++n2;
                ++n3;
            }
            if (this.dir_changes != null) {
                n2 = 0;
                while (n2 < this.files.length) {
                    if (this.files[n2] == null) break;
                    ++n2;
                }
                String[] stringArray = this.files;
                this.files = new String[n2];
                System.arraycopy(stringArray, 0, this.files, 0, n2);
                stringArray = this.dir_changes;
                this.dir_changes = new String[n2];
                System.arraycopy(stringArray, 0, this.dir_changes, 0, n2);
            }
        }
        switch (this.mode) {
            case 'c': {
                if (this.files != null) break;
                System.out.println("'c' flag requires that input files be specified!");
                this.printUsage();
                this.exit(1);
                break;
            }
            case 't': {
                XPFile xPFile;
                if (this.dir_changes != null) {
                    System.out.println("'t' flag can not be used with the -C flag!");
                    this.printUsage();
                    this.exit(1);
                }
                if (this.archive == null || (xPFile = new XPFile(this.archive)).exists()) break;
                System.out.println("archive \"" + xPFile.getPath() + "\" does not exist");
                this.exit(1);
                break;
            }
            case 'x': {
                XPFile xPFile;
                if (this.archive == null || (xPFile = new XPFile(this.archive)).exists()) break;
                System.out.println("archive \"" + xPFile.getPath() + "\" does not exist");
                this.exit(1);
                break;
            }
            case 'u': {
                if (this.files == null || this.archive == null) {
                    System.out.println("'u' flag requires that manifest or archive or input files be specified!");
                    this.printUsage();
                    this.exit(1);
                }
                if (this.archive == null) break;
                XPFile xPFile = new XPFile(this.archive);
                if (!xPFile.exists()) {
                    System.out.println("archive \"" + xPFile.getPath() + "\" does not exist");
                }
                this.exit(1);
                break;
            }
            default: {
                System.out.println("One of the options -{ctxu} must be specified!");
                this.printUsage();
                this.exit(1);
            }
        }
        this.createFileLookupTable();
    }

    void printUsage() {
        PrintStream printStream = this.vout;
        printStream.println("Usage: jar {ctxu}[vfm0M] [jar-file] [manifest-file] [-C dir] files ...");
        printStream.println("Options:");
        printStream.print('\t');
        printStream.println("-c  create new archive");
        printStream.print('\t');
        printStream.println("-t  list table of contents for archive");
        printStream.print('\t');
        printStream.println("-x  extract named (or all) files from archive");
        printStream.print('\t');
        printStream.println("-u  update existing archive");
        printStream.print('\t');
        printStream.println("-v  generate verbose output on standard output");
        printStream.print('\t');
        printStream.println("-f  specify archive file name");
        printStream.print('\t');
        printStream.println("-m  include manifest information from specified manifest file");
        printStream.print('\t');
        printStream.println("-0  store only; use no ZIP compression");
        printStream.print('\t');
        printStream.println("-M  Do not create a manifest file for the entries");
        printStream.print('\t');
        printStream.println("-C  change to the specified directory and include the following files");
        printStream.println("If any file is a directory then it is processed recursively.");
        printStream.println("The manifest file name and the archive file name needs to be specified");
        printStream.println("in the same order the 'm' and 'f' flags are specified.");
        printStream.println();
        printStream.println("Example 1: to archive two class files into an archive called classes.jar:");
        printStream.print('\t');
        printStream.println("jar cvf classes.jar Foo.class Bar.class");
        printStream.println("Example 2: use an existing manifest file 'mymanifest' and archive all the");
        printStream.print('\t');
        printStream.print('\t');
        printStream.println("files in the foo/ directory into 'classes.jar':");
        printStream.print('\t');
        printStream.println("jar cvfm classes.jar mymanifest -C foo/ .");
    }

    void processJar() throws IOException {
        switch (this.mode) {
            case 'c': {
                this.createJar(this.files, this.absolute_files);
                this.exit(0);
            }
            case 't': {
                this.listFilesInJar(this.files);
                this.exit(0);
            }
            case 'x': {
                this.extractFilesInJar(this.files, this.absolute_files);
                this.exit(0);
            }
            case 'u': {
                this.updateFilesInJar(this.files, this.absolute_files);
                this.exit(0);
            }
        }
        System.out.println("Unexpected error, '" + this.mode + "' not matched");
        this.exit(1);
    }

    void createFileLookupTable() throws IOException {
        if (this.files == null) {
            return;
        }
        XPFile xPFile = null;
        boolean bl = this.mode == 'u' || this.mode == 'c';
        boolean bl2 = false;
        this.absolute_files = new String[this.files.length];
        int n = 0;
        while (n < this.files.length) {
            String string;
            XPFile xPFile2;
            this.files[n] = this.files[n].replace('\\', '/');
            if (this.dir_changes != null && this.dir_changes[n] != null) {
                xPFile = new XPFile(this.dir_changes[n]);
            }
            if (!(xPFile2 = new XPFile(this.files[n])).isAbsolute()) {
                xPFile2 = new XPFile(xPFile, this.files[n]);
            }
            if (xPFile2.isAbsolute()) {
                string = this.files[n];
                int n2 = string.indexOf(47);
                if (n2 == -1) {
                    throw new RuntimeException("absolute file " + string + " had no '/' chars in it");
                }
                if (n2 + 1 < string.length()) {
                    this.files[n] = string.substring(n2 + 1);
                }
            }
            string = xPFile2.getAbsolutePath();
            String string2 = xPFile2.getCanonicalPath();
            if (string2.length() < string.length()) {
                int n3 = string2.lastIndexOf(47);
                if (n3 == -1) {
                    throw new RuntimeException("absolute file " + string2 + " had no '/' chars in it");
                }
                if (n3 + 1 < string2.length()) {
                    this.files[n] = string2.substring(n3 + 1);
                }
            }
            if (bl && !xPFile2.exists()) {
                bl2 = true;
                System.out.println(xPFile2.getPath() + ": no such file or directory");
            }
            this.absolute_files[n] = string;
            ++n;
        }
        if (bl2) {
            this.exit(2);
        }
    }

    /*
     * Unable to fully structure code
     */
    void listFilesInJar(String[] var1_1) throws IOException {
        var2_2 = this.archive == null ? new ZipInputStream(System.in) : new ZipInputStream(new XPFileInputStream(this.archive));
        try {
            while ((var3_3 = var2_2.getNextEntry()) != null) {
                block9: {
                    block10: {
                        var2_2.closeEntry();
                        var6_4 = var3_3.getName();
                        v0 = var7_5 = var1_1 == null;
                        if (!var7_5) {
                            var8_6 = 0;
                            while (var8_6 < var1_1.length) {
                                if (var6_4.equals(var1_1[var8_6])) {
                                    var7_5 = true;
                                }
                                ++var8_6;
                            }
                        }
                        if (!var7_5) continue;
                        if (!this.verbose) break block9;
                        var8_6 = 6;
                        var9_7 = String.valueOf(var3_3.getSize());
                        if (var9_7.length() <= var8_6) ** GOTO lbl23
                        this.vout.print(var9_7);
                        break block10;
lbl-1000:
                        // 1 sources

                        {
                            this.vout.print(' ');
                            --var8_6;
lbl23:
                            // 2 sources

                            ** while (var8_6 > var9_7.length())
                        }
lbl24:
                        // 1 sources

                        this.vout.print(var9_7);
                    }
                    this.vout.print(' ');
                    var10_8 = new Date(var3_3.getTime());
                    this.vout.print(var10_8);
                    this.vout.print(' ');
                    this.vout.println(var6_4);
                    continue;
                }
                this.vout.println(var6_4);
            }
        }
        finally {
            var5_9 = null;
            var2_2.close();
        }
    }

    /*
     * Exception decompiling
     */
    void extractFilesInJar(String[] var1_1, String[] var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void updateFilesInJar(String[] stringArray, String[] stringArray2) throws IOException {
        throw new RuntimeException("not implemented yet");
    }

    void createJar(String[] stringArray, String[] stringArray2) throws IOException {
        OutputStream outputStream;
        if (this.archive == null) {
            outputStream = System.out;
            this.vout = System.err;
        } else {
            outputStream = new XPFileOutputStream(this.archive);
        }
        JarOutputStream jarOutputStream = null;
        try {
            Object object;
            if (this.create_manifest) {
                String[] stringArray3;
                Manifest manifest;
                if (this.manifest == null) {
                    manifest = new Manifest();
                } else {
                    object = null;
                    try {
                        object = new BufferedInputStream(new XPFileInputStream(this.manifest));
                        manifest = new Manifest((InputStream)object);
                    }
                    finally {
                        stringArray3 = null;
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
                object = manifest.getMainAttributes();
                ((Attributes)object).put(Attributes.Name.MANIFEST_VERSION, "1.0");
                int n = 0;
                while (n < stringArray2.length) {
                    stringArray3 = new String[]{"MD5", "SHA"};
                    XPFile xPFile = new XPFile(stringArray2[n]);
                    String string = stringArray[n];
                    if (xPFile.isFile()) {
                        Attributes attributes = manifest.getAttributes(string);
                        if (attributes == null) {
                            attributes = new Attributes();
                            manifest.getEntries().put(string, attributes);
                        }
                        attributes.putValue("Name", string);
                        StringBuffer stringBuffer = new StringBuffer();
                        int n2 = 0;
                        while (n2 < stringArray3.length) {
                            block29: {
                                DigestInputStream digestInputStream;
                                try {
                                    digestInputStream = new DigestInputStream(new BufferedInputStream(new XPFileInputStream(xPFile)), MessageDigest.getInstance(stringArray3[n2]));
                                }
                                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                    break block29;
                                }
                                byte[] byArray = new byte[1024];
                                while (digestInputStream.read(byArray, 0, byArray.length) != -1) {
                                }
                                byte[] byArray2 = digestInputStream.getMessageDigest().digest();
                                attributes.putValue(stringArray3[n2] + "-Digest", new String(Base64.encode((byte[])byArray2)));
                                if (stringBuffer.length() != 0) {
                                    stringBuffer.append(' ');
                                }
                                stringBuffer.append(stringArray3[n2]);
                            }
                            ++n2;
                        }
                        if (stringBuffer.length() > 0) {
                            attributes.putValue("Digest-Algorithms", stringBuffer.toString());
                        }
                    }
                    ++n;
                }
                jarOutputStream = new JarOutputStream(outputStream, manifest);
                if (this.verbose) {
                    this.vout.println("added manifest");
                }
            } else {
                jarOutputStream = new JarOutputStream(outputStream);
            }
            int n = 0;
            while (n < stringArray.length) {
                object = new XPFile(stringArray2[n]);
                if (((File)object).isFile()) {
                    this.addEntry(jarOutputStream, stringArray[n], (XPFile)object);
                } else {
                    this.addEntryDir(jarOutputStream, stringArray[n], (XPFile)object);
                }
                ++n;
            }
        }
        finally {
            Object var6_21 = null;
            if (jarOutputStream != null) {
                jarOutputStream.close();
            } else {
                outputStream.close();
            }
        }
    }

    void addEntry(ZipOutputStream zipOutputStream, String string, XPFile xPFile) throws IOException {
        Object object;
        XPFile xPFile2;
        Object object2;
        if (this.archive != null && ((File)(object2 = new XPFile(new XPFile(this.archive).getCanonicalPath()))).equals(xPFile2 = new XPFile(xPFile.getCanonicalPath()))) {
            return;
        }
        if (xPFile.isDirectory()) {
            throw new Error("internal error");
        }
        object2 = new ZipEntry(string);
        long l = xPFile.length();
        if (this.compression) {
            ((ZipEntry)object2).setMethod(8);
        } else {
            ((ZipEntry)object2).setMethod(0);
            ((ZipEntry)object2).setSize(l);
            object = new CRC32();
            XPFileInputStream xPFileInputStream = new XPFileInputStream(xPFile);
            try {
                CheckedInputStream checkedInputStream = new CheckedInputStream(xPFileInputStream, (Checksum)object);
                Jar jar = this;
                if (jar == null) {
                    throw null;
                }
                this.readwriteStreams(checkedInputStream, new OutputStream(jar){
                    private final /* synthetic */ Jar this$0;

                    public void write(int n) {
                    }

                    public void write(byte[] byArray, int n, int n2) {
                    }
                    {
                        this.this$0 = jar;
                        this.constructor$0(jar);
                    }

                    private final void constructor$0(Jar jar) {
                    }
                });
            }
            finally {
                Object var10_11 = null;
                ((InputStream)xPFileInputStream).close();
            }
            ((ZipEntry)object2).setCrc(((CRC32)object).getValue());
        }
        zipOutputStream.putNextEntry((ZipEntry)object2);
        if (this.verbose) {
            this.vout.print("adding: " + string + " ");
            this.vout.print("(in=" + l + ") ");
        }
        object = new XPFileInputStream(xPFile);
        try {
            this.readwriteStreams((InputStream)object, zipOutputStream);
        }
        finally {
            Object var9_15 = null;
            ((InputStream)object).close();
        }
        zipOutputStream.closeEntry();
        if (this.verbose) {
            int n;
            long l2 = ((ZipEntry)object2).getSize();
            long l3 = ((ZipEntry)object2).getCompressedSize();
            this.vout.print("(out=" + l3 + ") ");
            if (l2 == l3) {
                n = 0;
            } else if (l2 > l3) {
                n = Math.round((float)l3 / (float)l2 * 100.0f);
                if (n == 0) {
                    n = 99;
                }
            } else {
                n = Math.round((float)(l3 - l2) / (float)l2 * -100.0f);
            }
            if (this.compression && l2 != l3) {
                this.vout.print("(deflated " + n + "%)");
            } else {
                this.vout.print("(stored " + n + "%)");
            }
            this.vout.println();
        }
    }

    void addEntryDir(ZipOutputStream zipOutputStream, String string, XPFile xPFile) throws IOException {
        if (!xPFile.isDirectory()) {
            throw new RuntimeException(xPFile.getPath() + " is not a file and it is not a directory");
        }
        String[] stringArray = xPFile.list();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            XPFile xPFile2 = new XPFile(xPFile, string2);
            String string3 = new XPFile(string, string2).getPath();
            if (xPFile2.isFile()) {
                this.addEntry(zipOutputStream, string3, xPFile2);
            } else {
                this.addEntryDir(zipOutputStream, string3, xPFile2);
            }
            ++n;
        }
    }

    void readwriteStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        boolean bl = false;
        while ((n = inputStream.read(this.buffer, 0, this.buffer.length)) != -1) {
            outputStream.write(this.buffer, 0, n);
        }
    }

    void ensureParentsExist(String string) {
        XPFile xPFile = new XPFile(string);
        String string2 = xPFile.getParent();
        if (string2 != null) {
            File file = new File(string2);
            file.mkdirs();
        }
    }

    void dump() {
        System.out.println("Called dump()");
        int n = 0;
        while (n < this.argv.length) {
            System.out.println("argv[" + n + "] is \"" + this.argv[n] + "\"");
            ++n;
        }
        System.out.println("manifest is \"" + this.manifest + "\"");
        System.out.println("create_manifest is \"" + this.create_manifest + "\"");
        System.out.println("archive is \"" + this.archive + "\"");
        System.out.println("compression is \"" + this.compression + "\"");
        System.out.println("verbose is \"" + this.verbose + "\"");
        System.out.println("mode is \"" + this.mode + "\"");
        if (this.files == null) {
            System.out.println("no files");
        } else {
            System.out.println(this.files.length + " files to process");
            n = 0;
            while (n < this.files.length) {
                System.out.println("files[" + n + "] is \"" + this.files[n] + "\"");
                ++n;
            }
        }
        if (this.dir_changes == null) {
            System.out.println("no dir changes");
        } else {
            n = 0;
            while (n < this.files.length) {
                System.out.println("dir_changes[" + n + "] is \"" + this.dir_changes[n] + "\"");
                ++n;
            }
        }
        if (this.absolute_files == null) {
            System.out.println("no absolute file names");
        } else {
            n = 0;
            while (n < this.absolute_files.length) {
                System.out.println("absolute_files[" + n + "] is \"" + this.absolute_files[n] + "\"");
                ++n;
            }
        }
    }

    public Jar(String[] stringArray) {
        this.bufferSize = 8192;
        this.argv = stringArray;
    }
}

