/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CLineError;
import at.dms.kjc.CSwitchGroupContext;
import at.dms.kjc.CodeLabel;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JPhylum;
import at.dms.kjc.JStatement;
import at.dms.kjc.JSwitchLabel;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;
import java.util.Vector;

public class JSwitchGroup
extends JPhylum {
    private JSwitchLabel[] labels;
    private JStatement[] stmts;
    private CodeLabel pos;

    public JStatement[] getStatements() {
        return this.stmts;
    }

    public void analyse(CSwitchGroupContext cSwitchGroupContext) throws PositionedError {
        int n = 0;
        while (n < this.labels.length) {
            this.labels[n].analyse(cSwitchGroupContext);
            ++n;
        }
        cSwitchGroupContext.setReachable(true);
        n = 0;
        while (n < this.stmts.length) {
            try {
                if (!cSwitchGroupContext.isReachable()) {
                    throw new CLineError(this.stmts[n].getTokenReference(), KjcMessages.STATEMENT_UNREACHABLE);
                }
                this.stmts[n].analyse(cSwitchGroupContext);
            }
            catch (CLineError cLineError) {
                cSwitchGroupContext.reportTrouble(cLineError);
            }
            ++n;
        }
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitSwitchGroup(this, this.labels, this.stmts);
    }

    public void collectLabels(CodeLabel codeLabel, Vector vector, Vector vector2) {
        this.pos = null;
        int n = 0;
        while (this.pos == null && n < this.labels.length) {
            if (this.labels[n].isDefault()) {
                this.pos = codeLabel;
            }
            ++n;
        }
        if (this.pos == null) {
            this.pos = new CodeLabel();
            n = 0;
            while (n < this.labels.length) {
                vector.addElement(this.labels[n].getLabel());
                vector2.addElement(this.pos);
                ++n;
            }
        }
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        codeSequence.plantLabel(this.pos);
        int n = 0;
        while (n < this.stmts.length) {
            this.stmts[n].genCode(codeSequence);
            ++n;
        }
    }

    public JSwitchGroup(TokenReference tokenReference, JSwitchLabel[] jSwitchLabelArray, JStatement[] jStatementArray) {
        super(tokenReference);
        this.labels = jSwitchLabelArray;
        this.stmts = jStatementArray;
    }
}

