/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.CWarning;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.UnpositionedError;
import at.dms.kjc.CClass;
import at.dms.kjc.CClassType;
import at.dms.kjc.CContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CMethod;
import at.dms.kjc.CMethodNotFoundError;
import at.dms.kjc.CSourceMethod;
import at.dms.kjc.CStdType;
import at.dms.kjc.CThrowableInfo;
import at.dms.kjc.CType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JExpression;
import at.dms.kjc.JNameExpression;
import at.dms.kjc.JSuperExpression;
import at.dms.kjc.JThisExpression;
import at.dms.kjc.JTypeNameExpression;
import at.dms.kjc.KjcMessages;
import at.dms.kjc.KjcVisitor;

public class JMethodCallExpression
extends JExpression {
    protected JExpression prefix;
    protected final String ident;
    protected JExpression[] args;
    protected CMethod method;

    public CType getType() {
        return this.method.getReturnType();
    }

    public boolean isStatementExpression() {
        return true;
    }

    public JExpression analyse(CExpressionContext cExpressionContext) throws PositionedError {
        CType[] cTypeArray = new CType[this.args.length];
        int n = 0;
        while (n < cTypeArray.length) {
            this.args[n] = this.args[n].analyse(new CExpressionContext(cExpressionContext));
            cTypeArray[n] = this.args[n].getType();
            ++n;
        }
        CClass cClass = cExpressionContext.getClassContext().getCClass();
        if (this.prefix != null) {
            this.prefix = this.prefix.analyse(new CExpressionContext(cExpressionContext));
            if (this.prefix instanceof JNameExpression) {
                this.check((CContext)cExpressionContext, false, KjcMessages.BAD_METHOD_NAME, ((JNameExpression)this.prefix).getName());
            }
            this.check(cExpressionContext, this.prefix.getType().isReference(), KjcMessages.METHOD_BADPREFIX, this.ident, this.prefix.getType());
            this.check((CContext)cExpressionContext, this.prefix.getType().getCClass().isAccessible(cClass), KjcMessages.CLASS_NOACCESS, this.prefix.getType().getCClass());
            try {
                this.method = this.prefix.getType().getCClass().lookupMethod(cClass, this.ident, cTypeArray);
            }
            catch (UnpositionedError unpositionedError) {
                throw unpositionedError.addPosition(this.getTokenReference());
            }
        }
        try {
            this.method = cExpressionContext.lookupMethod(cClass, this.ident, cTypeArray);
        }
        catch (UnpositionedError unpositionedError) {
            throw unpositionedError.addPosition(this.getTokenReference());
        }
        if (this.method == null) {
            String string = this.prefix instanceof JNameExpression ? ((JNameExpression)this.prefix).getQualifiedName() + "." : (this.prefix instanceof JTypeNameExpression ? ((JTypeNameExpression)this.prefix).getQualifiedName() + "." : "");
            throw new CMethodNotFoundError(this.getTokenReference(), this, string + this.ident, cTypeArray);
        }
        CClassType[] cClassTypeArray = this.method.getThrowables();
        int n2 = 0;
        while (n2 < cClassTypeArray.length) {
            if (!(!cClassTypeArray[n2].isCheckedException() || this.prefix != null && this.prefix.getType().isArrayType() && this.ident == "clone" && cClassTypeArray[n2].getCClass().getQualifiedName().equals("java/lang/CloneNotSupportedException"))) {
                cExpressionContext.getBodyContext().addThrowable(new CThrowableInfo(cClassTypeArray[n2], this));
            }
            ++n2;
        }
        CClass cClass2 = this.method.getOwner();
        if (this.prefix == null && !this.method.isStatic()) {
            this.prefix = cClass2 == cClass ? new JThisExpression(this.getTokenReference()) : new JThisExpression(this.getTokenReference(), cClass2);
            this.prefix = this.prefix.analyse(cExpressionContext);
        }
        this.check((CContext)cExpressionContext, this.method.isStatic() || !(this.prefix instanceof JTypeNameExpression), KjcMessages.METHOD_STATIC_BAD, this.method.getIdent());
        if (this.method.isStatic() && this.prefix != null && !(this.prefix instanceof JTypeNameExpression)) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.INSTANCE_PREFIXES_STATIC_METHOD, this.method.getIdent(), this.prefix.getType()));
        }
        cTypeArray = this.method.getParameters();
        int n3 = 0;
        while (n3 < cTypeArray.length) {
            if (this.args[n3] instanceof JTypeNameExpression) {
                this.check((CContext)cExpressionContext, false, KjcMessages.VAR_UNKNOWN, ((JTypeNameExpression)this.args[n3]).getQualifiedName());
            }
            this.args[n3] = this.args[n3].convertType(cTypeArray[n3], cExpressionContext);
            ++n3;
        }
        if (this.method instanceof CSourceMethod) {
            ((CSourceMethod)this.method).setUsed();
        }
        if (this.method.getReturnType() != CStdType.Void && cExpressionContext.discardValue()) {
            cExpressionContext.reportTrouble(new CWarning(this.getTokenReference(), KjcMessages.UNUSED_RETURN_VALUE_FROM_FUNCTION_CALL, (Object)this.method.getIdent()));
        }
        return this;
    }

    public void accept(KjcVisitor kjcVisitor) {
        kjcVisitor.visitMethodCallExpression(this, this.prefix, this.ident, this.args);
    }

    public void genCode(CodeSequence codeSequence, boolean bl) {
        this.setLineNumber(codeSequence);
        boolean bl2 = false;
        if (!this.method.isStatic()) {
            this.prefix.genCode(codeSequence, false);
            if (this.prefix instanceof JSuperExpression) {
                bl2 = true;
            }
        } else if (this.prefix != null) {
            this.prefix.genCode(codeSequence, true);
        }
        int n = 0;
        while (n < this.args.length) {
            this.args[n].genCode(codeSequence, false);
            ++n;
        }
        this.method.genCode(codeSequence, bl2);
        if (bl) {
            codeSequence.plantPopInstruction(this.getType());
        }
    }

    public JMethodCallExpression(TokenReference tokenReference, JExpression jExpression, String string, JExpression[] jExpressionArray) {
        super(tokenReference);
        this.prefix = jExpression;
        this.ident = string.intern();
        this.args = jExpressionArray;
    }
}

