/*
 * Decompiled with CFR 0.152.
 */
package at.dms.kjc;

import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.kjc.CBodyContext;
import at.dms.kjc.CConstructorContext;
import at.dms.kjc.CExpressionContext;
import at.dms.kjc.CMethod;
import at.dms.kjc.CSourceClass;
import at.dms.kjc.CStdType;
import at.dms.kjc.CodeSequence;
import at.dms.kjc.JBlock;
import at.dms.kjc.JConstructorCall;
import at.dms.kjc.JExpression;
import at.dms.kjc.JExpressionStatement;
import at.dms.kjc.JMethodCallExpression;
import at.dms.kjc.JStatement;

public class JConstructorBlock
extends JBlock {
    private JConstructorCall constructorCall;
    private JStatement initializerCall;
    private CSourceClass sourceClass;
    private int paramsLength;

    public CMethod getCalledConstructor() {
        return this.constructorCall == null ? null : this.constructorCall.getMethod();
    }

    public void analyse(CBodyContext cBodyContext) throws PositionedError {
        this.sourceClass = (CSourceClass)cBodyContext.getClassContext().getCClass();
        if (this.constructorCall == null && !this.sourceClass.getType().equals(CStdType.Object)) {
            this.constructorCall = new JConstructorCall(this.getTokenReference(), false, JExpression.EMPTY);
        }
        if (this.sourceClass.isNested()) {
            this.paramsLength = cBodyContext.getMethodContext().getCMethod().getParameters().length;
        }
        this.initializerCall = !cBodyContext.getClassContext().hasInitializer() || this.constructorCall == null || this.constructorCall.isThisInvoke() ? null : new JExpressionStatement(this.getTokenReference(), new JMethodCallExpression(this.getTokenReference(), null, "Block$", JExpression.EMPTY), null);
        if (this.constructorCall != null) {
            this.constructorCall.analyse(new CExpressionContext(cBodyContext));
            if (this.constructorCall.isThisInvoke()) {
                ((CConstructorContext)cBodyContext.getMethodContext()).markAllFieldToInitialized();
            }
        }
        if (this.initializerCall != null) {
            this.initializerCall.analyse(cBodyContext);
            ((CConstructorContext)cBodyContext.getMethodContext()).adoptInitializerInfo();
        }
        super.analyse(cBodyContext);
    }

    public void genCode(CodeSequence codeSequence) {
        this.setLineNumber(codeSequence);
        if (this.constructorCall != null) {
            this.constructorCall.genCode(codeSequence, true);
        }
        if (this.sourceClass.isNested()) {
            this.sourceClass.genInit(codeSequence, this.paramsLength);
        }
        if (this.initializerCall != null) {
            this.initializerCall.genCode(codeSequence);
        }
        int n = 0;
        while (n < this.body.length) {
            this.body[n].genCode(codeSequence);
            ++n;
        }
        codeSequence.plantNoArgInstruction(177);
    }

    public JConstructorBlock(TokenReference tokenReference, JConstructorCall jConstructorCall, JStatement[] jStatementArray) {
        super(tokenReference, jStatementArray, null);
        this.constructorCall = jConstructorCall;
    }
}

