/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.optgen;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.tools.optgen.DefinitionFile;
import at.dms.compiler.tools.optgen.OptgenError;
import at.dms.compiler.tools.optgen.OptgenOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Main {
    private OptgenOptions options;
    private DefinitionFile definition;

    public static void main(String[] stringArray) {
        boolean bl = new Main().run(stringArray);
        System.exit(bl ? 0 : 1);
    }

    private boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.options.nonOptions.length) {
            bl = !this.processFile(this.options.nonOptions[n]);
            ++n;
        }
        return !bl;
    }

    private boolean parseArguments(String[] stringArray) {
        this.options = new OptgenOptions();
        if (!this.options.parseCommandLine(stringArray)) {
            return false;
        }
        if (this.options.nonOptions.length == 0) {
            System.err.println(CompilerMessages.NO_INPUT_FILE.getFormat());
            this.options.usage();
            return false;
        }
        return true;
    }

    private boolean processFile(String string) {
        if (!this.parseSource(string)) {
            return false;
        }
        if (this.options.release != null) {
            this.definition.setVersion(this.options.release);
        }
        if (!this.checkIdentifiers()) {
            return false;
        }
        if (!this.checkShortcuts()) {
            return false;
        }
        return this.buildInterfaceFile();
    }

    private boolean parseSource(String string) {
        boolean bl = false;
        try {
            this.definition = DefinitionFile.read(string);
        }
        catch (OptgenError optgenError) {
            System.err.println(optgenError.getMessage());
            bl = true;
        }
        return !bl;
    }

    private boolean checkIdentifiers() {
        boolean bl = false;
        try {
            this.definition.checkIdentifiers();
        }
        catch (OptgenError optgenError) {
            System.err.println(optgenError.getMessage());
            bl = true;
        }
        return !bl;
    }

    private boolean checkShortcuts() {
        boolean bl = false;
        try {
            this.definition.checkShortcuts();
        }
        catch (OptgenError optgenError) {
            System.err.println(optgenError.getMessage());
            bl = true;
        }
        return !bl;
    }

    private boolean buildInterfaceFile() {
        String string = this.definition.getPrefix();
        File file = new File(string + "Options.java");
        boolean bl = false;
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            this.definition.printFile(printWriter);
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception on " + file.getPath() + ": " + iOException.getMessage());
            bl = true;
        }
        return !bl;
    }

    private Main() {
    }
}

