/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.lexgen;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.tools.antlr.runtime.ParserException;
import at.dms.compiler.tools.lexgen.LexgenError;
import at.dms.compiler.tools.lexgen.LexgenLexer;
import at.dms.compiler.tools.lexgen.LexgenParser;
import at.dms.compiler.tools.lexgen.TokenDefinition;
import at.dms.util.Utils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

class DefinitionFile {
    private static final String DEFAULT_LITERAL_PREFIX = "LITERAL_";
    private final String sourceFile;
    private final String packageName;
    private final String vocabulary;
    private final String prefix;
    private final TokenDefinition[] definitions;
    private static /* synthetic */ Class class$Lat$dms$compiler$tools$lexgen$TokenDefinition;

    public static DefinitionFile read(String string) throws LexgenError {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            LexgenLexer lexgenLexer = new LexgenLexer(bufferedInputStream);
            LexgenParser lexgenParser = new LexgenParser(lexgenLexer);
            DefinitionFile definitionFile = lexgenParser.aCompilationUnit(string);
            ((InputStream)bufferedInputStream).close();
            return definitionFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LexgenError(CompilerMessages.FILE_NOT_FOUND, string);
        }
        catch (IOException iOException) {
            throw new LexgenError(CompilerMessages.IO_EXCEPTION, string, iOException.getMessage());
        }
        catch (ParserException parserException) {
            throw new LexgenError(CompilerMessages.FORMATTED_ERROR, (Object)new PositionedError(new TokenReference(string, parserException.getLine()), CompilerMessages.SYNTAX_ERROR, (Object)parserException.getMessage()));
        }
    }

    public int checkIdentifiers(Hashtable hashtable, String string, int n) throws LexgenError {
        int n2 = 0;
        while (n2 < this.definitions.length) {
            this.definitions[n2].checkIdentifiers(hashtable, string, n++, this.sourceFile);
            ++n2;
        }
        return n;
    }

    public void printDefinition(PrintWriter printWriter, String string) {
        printWriter.println();
        printWriter.println("// Definitions from " + this.sourceFile);
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].printDefinition(printWriter, string);
            ++n;
        }
    }

    public void printInterface(PrintWriter printWriter, String string, boolean bl) {
        printWriter.print("// Generated from " + this.sourceFile);
        printWriter.println();
        printWriter.println("package " + this.packageName + ";");
        printWriter.println();
        printWriter.print("public interface " + this.vocabulary + "TokenTypes");
        if (string != null) {
            printWriter.print(" extends " + string);
        }
        printWriter.println(" {");
        if (string == null) {
            printWriter.println("  int\tEOF = 1;");
            printWriter.println("  int\tNULL_TREE_LOOKAHEAD = 3;");
        }
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].printInterface(printWriter, this.prefix);
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < this.definitions.length) {
                this.definitions[n].printToken(printWriter, this.prefix);
                ++n;
            }
        }
        printWriter.println("}");
    }

    public void printFlexRules(PrintWriter printWriter) {
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].printFlexRule(printWriter, this.prefix);
            ++n;
        }
    }

    public void putKeywords(Vector vector, Vector vector2, String string) {
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].putKeyword(vector, vector2, string);
            ++n;
        }
    }

    public String getClassName() {
        return this.packageName + "." + this.vocabulary + "TokenTypes";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public String getPrefix() {
        return this.prefix;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DefinitionFile(String string, String string2, String string3, String string4, Vector vector) {
        this.sourceFile = string;
        this.packageName = string2;
        this.vocabulary = string3;
        this.prefix = string4 == null ? DEFAULT_LITERAL_PREFIX : string4;
        this.definitions = (TokenDefinition[])Utils.toArray(vector, class$Lat$dms$compiler$tools$lexgen$TokenDefinition != null ? class$Lat$dms$compiler$tools$lexgen$TokenDefinition : (class$Lat$dms$compiler$tools$lexgen$TokenDefinition = DefinitionFile.class$("at.dms.compiler.tools.lexgen.TokenDefinition")));
    }
}

