/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.antlr.compiler;

import at.dms.compiler.tools.antlr.compiler.GrammarDefinition;
import at.dms.compiler.tools.antlr.compiler.Hierarchy;
import at.dms.compiler.tools.antlr.compiler.IndexedVector;
import at.dms.compiler.tools.antlr.compiler.Main;
import at.dms.compiler.tools.antlr.compiler.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class GrammarFile {
    protected String fileName;
    protected String headerAction = "";
    protected IndexedVector options;
    protected IndexedVector grammars;
    protected boolean expanded = false;

    public void addGrammar(GrammarDefinition grammarDefinition) {
        this.grammars.appendElement(grammarDefinition.getName(), grammarDefinition);
    }

    public void generateExpandedFile(Main main) throws IOException {
        if (!this.expanded) {
            return;
        }
        String string = this.nameForExpandedGrammarFile(this.getName());
        PrintWriter printWriter = main.openOutputFile(string);
        printWriter.println(this.toString());
        printWriter.close();
    }

    public IndexedVector getGrammars() {
        return this.grammars;
    }

    public String getName() {
        return this.fileName;
    }

    public String nameForExpandedGrammarFile(String string) {
        if (this.expanded) {
            return "expanded" + Utils.fileMinusPath(string);
        }
        return string;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public void addHeaderAction(String string) {
        this.headerAction = this.headerAction + string + System.getProperty("line.separator");
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public String toString() {
        String string = this.headerAction == null ? "" : this.headerAction;
        String string2 = this.options == null ? "" : Hierarchy.optionsToString(this.options);
        String string3 = string + string2;
        Enumeration enumeration = this.grammars.elements();
        while (enumeration.hasMoreElements()) {
            GrammarDefinition grammarDefinition = (GrammarDefinition)enumeration.nextElement();
            string3 = string3 + grammarDefinition;
        }
        return string3;
    }

    public GrammarFile(String string) {
        this.fileName = string;
        this.grammars = new IndexedVector();
    }
}

