/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.Attribute;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.LineNumberInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LineNumberTable
extends Attribute {
    private static AsciiConstant attr = new AsciiConstant("LineNumberTable");
    private LineNumberInfo[] entries;

    int getTag() {
        return 5;
    }

    int getSize() {
        return 8 + 4 * this.entries.length;
    }

    LineNumberInfo[] getLineNumbers() {
        return this.entries;
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(attr);
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(attr.getIndex());
        dataOutput.writeInt(2 + 4 * this.entries.length);
        dataOutput.writeShort(this.entries.length);
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n].write(dataOutput);
            ++n;
        }
    }

    public LineNumberTable(LineNumberInfo[] lineNumberInfoArray) {
        this.entries = lineNumberInfoArray;
    }

    public LineNumberTable(DataInput dataInput, ConstantPool constantPool, Instruction[] instructionArray) throws IOException {
        dataInput.readInt();
        this.entries = new LineNumberInfo[dataInput.readUnsignedShort()];
        int n = 0;
        while (n < this.entries.length) {
            this.entries[n] = new LineNumberInfo(dataInput, constantPool, instructionArray);
            ++n;
        }
    }
}

