/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.CodeEnv;
import at.dms.classfile.CodePosition;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import at.dms.classfile.InstructionHandle;
import at.dms.classfile.OpcodeNames;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class JumpInstruction
extends Instruction
implements AccessorContainer {
    private InstructionAccessor target;
    private boolean wide;

    public boolean canComplete() {
        return this.getOpcode() != 167 && this.getOpcode() != 200;
    }

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        this.target = this.target.transform(accessorTransformer, this);
    }

    public void setTarget(InstructionAccessor instructionAccessor) {
        this.target = instructionAccessor;
    }

    public InstructionAccessor getTarget() {
        return this.target;
    }

    int getSize() {
        return this.getSize(this.wide);
    }

    private int getSize(boolean bl) {
        switch (this.getOpcode()) {
            case 167: 
            case 168: 
            case 200: 
            case 201: {
                return bl ? 5 : 3;
            }
        }
        return bl ? 8 : 3;
    }

    void check(CodeEnv codeEnv, int n) throws ClassFileFormatException {
        if (this.getOpcode() == 201 || this.getOpcode() == 168) {
            codeEnv.checkExecutionPath((InstructionHandle)this.target, n + 1);
        } else {
            codeEnv.checkExecutionPath((InstructionHandle)this.target, n);
        }
    }

    void computeEndAddress(CodePosition codePosition) {
        boolean bl;
        boolean bl2;
        CodePosition codePosition2 = ((InstructionHandle)this.target).getPosition();
        if (codePosition2.min == -1) {
            bl2 = false;
            bl = true;
        } else if (codePosition2.min < codePosition.max) {
            bl2 = codePosition2.max - codePosition.min < Short.MIN_VALUE;
            bl = codePosition2.min - codePosition.max < Short.MIN_VALUE;
        } else {
            bl2 = codePosition2.min - codePosition.max > Short.MAX_VALUE;
            bl = codePosition2.max - codePosition.min > Short.MAX_VALUE;
        }
        codePosition.min += this.getSize(bl2);
        codePosition.max += this.getSize(bl);
        if (bl2 == bl) {
            this.wide = bl2;
            switch (this.getOpcode()) {
                case 167: 
                case 200: {
                    this.setOpcode(this.wide ? 200 : 167);
                    break;
                }
                case 168: 
                case 201: {
                    this.setOpcode(this.wide ? 201 : 168);
                    break;
                }
            }
        }
    }

    public int getPushedOnStack() {
        switch (this.getOpcode()) {
            case 201: {
                return 2;
            }
            case 168: {
                return 1;
            }
        }
        return 0;
    }

    public byte getReturnType() {
        return 0;
    }

    public int getStack() {
        switch (this.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                return -1;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return -2;
            }
            case 167: 
            case 168: 
            case 200: 
            case 201: {
                return 0;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    void resolveConstants(ConstantPool constantPool) {
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        Instruction instruction = (Instruction)this.target;
        if (!this.wide) {
            dataOutput.writeByte((byte)this.getOpcode());
            dataOutput.writeShort((short)(instruction.getAddress() - this.getAddress()));
        } else {
            switch (this.getOpcode()) {
                case 200: 
                case 201: {
                    dataOutput.writeByte((byte)this.getOpcode());
                    dataOutput.writeInt(instruction.getAddress() - this.getAddress());
                    break;
                }
                default: {
                    dataOutput.writeByte((byte)JumpInstruction.getReverseOpcode(this.getOpcode()));
                    dataOutput.writeShort(8);
                    dataOutput.writeByte(-56);
                    dataOutput.writeInt(instruction.getAddress() - (this.getAddress() + 1 + 2));
                }
            }
        }
    }

    private static int getReverseOpcode(int n) {
        switch (n) {
            case 165: {
                return 166;
            }
            case 166: {
                return 165;
            }
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 161: {
                return 162;
            }
            case 164: {
                return 163;
            }
            case 163: {
                return 164;
            }
            case 162: {
                return 161;
            }
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 155: {
                return 156;
            }
            case 157: {
                return 158;
            }
            case 158: {
                return 157;
            }
            case 156: {
                return 155;
            }
            case 198: {
                return 199;
            }
            case 199: {
                return 198;
            }
        }
        throw new InconsistencyException("no reverse opcode for " + OpcodeNames.getName(n));
    }

    public void dump() {
        System.err.println("" + OpcodeNames.getName(this.getOpcode()) + " [" + this + "] ===> " + this.target);
    }

    public JumpInstruction(int n, InstructionAccessor instructionAccessor) {
        super(n);
        this.target = instructionAccessor;
    }
}

