/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ClassConstant;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class ClassRefInstruction
extends Instruction {
    private ClassConstant cst;

    public boolean canComplete() {
        return true;
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(this.cst);
    }

    int getSize() {
        return 3;
    }

    public ClassConstant getClassConstant() {
        return this.cst;
    }

    public byte getReturnType() {
        switch (this.getOpcode()) {
            case 192: {
                return 0;
            }
            case 187: 
            case 189: 
            case 193: {
                return 6;
            }
        }
        throw new InconsistencyException("invalid opcode " + this.getOpcode());
    }

    public int getPushedOnStack() {
        switch (this.getOpcode()) {
            case 192: {
                return 0;
            }
            case 187: 
            case 189: 
            case 193: {
                return 1;
            }
        }
        throw new InconsistencyException("invalid opcode " + this.getOpcode());
    }

    public int getStack() {
        switch (this.getOpcode()) {
            case 189: 
            case 192: 
            case 193: {
                return 0;
            }
            case 187: {
                return 1;
            }
        }
        throw new InconsistencyException("invalid opcode " + this.getOpcode());
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.getOpcode());
        dataOutput.writeShort(this.cst.getIndex());
    }

    public ClassRefInstruction(int n, String string) {
        super(n);
        this.cst = new ClassConstant(string);
    }

    public ClassRefInstruction(int n, ClassConstant classConstant) {
        super(n);
        this.cst = classConstant;
    }
}

