/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.ControlFlow;
import at.dms.backend.QNode;
import at.dms.backend.QNop;

public abstract class TreeWalker {
    private BasicBlock currentBlock;
    private BasicBlock[] bblocks;
    private BasicBlock[] eblocks;

    protected void traverse() {
        ControlFlow.setMarked(this.bblocks, false);
        this.traverseInstructions(this.bblocks[0]);
        int n = 0;
        while (n < this.eblocks.length) {
            this.traverseInstructions(this.eblocks[n]);
            ++n;
        }
    }

    protected BasicBlock getBasicBlock(int n) {
        return this.bblocks[n];
    }

    protected abstract void processNode(QNode var1);

    protected void kill() {
    }

    protected void removeNode(QNode qNode) {
        BasicBlock basicBlock = this.currentBlock;
        QNode[] qNodeArray = basicBlock.getQuadruples();
        int n = 0;
        while (n < qNodeArray.length) {
            if (qNodeArray[n] == qNode) {
                qNodeArray[n] = new QNop();
                return;
            }
            ++n;
        }
        BasicBlock[] basicBlockArray = basicBlock.getSuccessors();
        QNode[][] qNodeArray2 = basicBlock.getSuccessorAccess();
        int n2 = qNodeArray.length;
        int n3 = 0;
        while (n3 < basicBlockArray.length) {
            int n4 = 0;
            while (qNodeArray2[n3] != null && n4 < qNodeArray2[n3].length) {
                if (qNodeArray2[n3][n4] == qNode) {
                    qNodeArray2[n3][n4] = new QNop();
                    return;
                }
                ++n4;
            }
            ++n3;
        }
    }

    private void traverseInstructions(BasicBlock basicBlock) {
        if (basicBlock.isMarked()) {
            return;
        }
        basicBlock.setMarked(true);
        this.currentBlock = basicBlock;
        this.kill();
        boolean bl = false;
        QNode[] qNodeArray = basicBlock.getQuadruples();
        int n = 0;
        while (n < qNodeArray.length) {
            this.processNode(qNodeArray[n]);
            ++n;
        }
        BasicBlock[] basicBlockArray = basicBlock.getSuccessors();
        QNode[][] qNodeArray2 = basicBlock.getSuccessorAccess();
        int n2 = qNodeArray.length;
        if (basicBlockArray.length > 1) {
            this.kill();
        }
        int n3 = 0;
        while (n3 < basicBlockArray.length) {
            int n4 = 0;
            while (qNodeArray2[n3] != null && n4 < qNodeArray2[n3].length) {
                this.processNode(qNodeArray2[n3][n4]);
                ++n4;
            }
            this.traverseInstructions(basicBlockArray[n3]);
            ++n3;
        }
    }

    public TreeWalker(BasicBlock[] basicBlockArray, BasicBlock[] basicBlockArray2) {
        this.bblocks = basicBlockArray;
        this.eblocks = basicBlockArray2;
    }
}

