// Swarm library. Copyright  1996-2000 Swarm Development Group.
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// The Swarm Development Group can be reached via our website at:
// http://www.swarm.org/

#import <simtoolsgui.h> // GUISwarm
#import <objectbase/Swarm.h> // Swarm

// a GUISwarm is a Swarm with some support for graphical interface. In
// particular, it creates a control panel for you and also provides a
// "go" method that handles the user hitting buttons like "stop" and
// "step". When using this, you still need to be sure to schedule
// calls to the controlPanels' doTkEvents method.

@interface GUISwarm: Swarm <GUISwarm>
{
  id <ControlPanel> controlPanel;
  id <ActionCache> actionCache;
  const char *baseWindowGeometryRecordName;
  BOOL saveSizeFlag;
}

- setWindowGeometryRecordName: (const char *)windowGeometryRecordName;
- setSaveSizeFlag: (BOOL)saveSizeFlag;
- setWindowGeometryRecordNameForComponent: (const char *)componentName
                                   widget: aWidget;
- (id <ActionCache>)getActionCache;
- (id <ControlPanel>)getControlPanel;
- buildObjects;
- go;				   // returns Completed or ControlStateQuit
- (void)drop;
@end
