/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AttributedStringIterator
implements AttributedCharacterIterator {
    private CharacterIterator ci;
    private AttributedString.AttributeRange[] attribs;
    private AttributedCharacterIterator.Attribute[] restricts;

    AttributedStringIterator(StringCharacterIterator sci, AttributedString.AttributeRange[] attribs, int begin_index, int end_index, AttributedCharacterIterator.Attribute[] restricts) {
        this.ci = new StringCharacterIterator(sci, begin_index, end_index);
        this.attribs = attribs;
        this.restricts = restricts;
    }

    public Object clone() {
        return this.ci.clone();
    }

    public char current() {
        return this.ci.current();
    }

    public char next() {
        return this.ci.next();
    }

    public char previous() {
        return this.ci.previous();
    }

    public char first() {
        return this.ci.first();
    }

    public char last() {
        return this.ci.last();
    }

    public int getIndex() {
        return this.ci.getIndex();
    }

    public char setIndex(int index) {
        return this.ci.setIndex(index);
    }

    public int getBeginIndex() {
        return this.ci.getBeginIndex();
    }

    public int getEndIndex() {
        return this.ci.getEndIndex();
    }

    public Set getAllAttributeKeys() {
        HashSet s = new HashSet();
        if (this.attribs == null) {
            return s;
        }
        for (int i = 0; i < this.attribs.length; ++i) {
            Set key_set = this.attribs[i].attribs.keySet();
            Iterator iter = key_set.iterator();
            while (iter.hasNext()) {
                s.add(iter.next());
            }
        }
        return s;
    }

    public int getRunLimit() {
        return this.getRunLimit(this.getAttributes().keySet());
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attrib) {
        HashSet s = new HashSet();
        s.add(attrib);
        return this.getRunLimit(s);
    }

    public synchronized int getRunLimit(Set attribute_set) {
        int run_limit;
        boolean found;
        int orig_index = this.ci.getIndex();
        block0: do {
            run_limit = this.ci.getIndex();
            Map attribute_map = this.getAttributes();
            found = false;
            Iterator iter = attribute_set.iterator();
            while (iter.hasNext()) {
                if (attribute_map.containsKey(iter.next())) continue;
                found = true;
                continue block0;
            }
        } while (!found && this.ci.next() != '\uffff');
        boolean hit_end = this.ci.previous() == '\uffff';
        this.ci.setIndex(orig_index);
        if (run_limit == orig_index) {
            return -1;
        }
        return run_limit;
    }

    public int getRunStart() {
        return this.getRunStart(this.getAttributes().keySet());
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attrib) {
        HashSet s = new HashSet();
        s.add(attrib);
        return this.getRunStart(s);
    }

    public int getRunStart(Set attribute_set) {
        int run_start;
        Iterator iter;
        int orig_index = this.ci.getIndex();
        do {
            run_start = this.ci.getIndex();
            Map attribute_map = this.getAttributes();
            iter = attribute_set.iterator();
            while (iter.hasNext() && attribute_map.containsKey(iter.next())) {
            }
        } while (!iter.hasNext() && this.ci.previous() != '\uffff');
        boolean hit_beginning = this.ci.previous() == '\uffff';
        this.ci.setIndex(orig_index);
        if (run_start == orig_index) {
            return -1;
        }
        if (!hit_beginning) {
            ++run_start;
        }
        return run_start;
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attrib) {
        if (this.attribs == null) {
            return null;
        }
        for (int i = 0; i < this.attribs.length; ++i) {
            Set key_set = this.attribs[i].attribs.keySet();
            Iterator iter = key_set.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!obj.equals(attrib) || this.ci.getIndex() < this.attribs[i].begin_index || this.ci.getIndex() > this.attribs[i].end_index) continue;
                return this.attribs[i].attribs.get(obj);
            }
        }
        return null;
    }

    public Map getAttributes() {
        HashMap m = new HashMap();
        if (this.attribs == null) {
            return m;
        }
        for (int i = 0; i < this.attribs.length; ++i) {
            if (this.ci.getIndex() < this.attribs[i].begin_index || this.ci.getIndex() > this.attribs[i].end_index) continue;
            m.putAll(this.attribs[i].attribs);
        }
        return m;
    }
}

