/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import gnu.java.nio.charset.Provider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class Charset
implements Comparable {
    private static CharsetEncoder cachedEncoder;
    private static CharsetDecoder cachedDecoder;
    private final String canonicalName;
    private final String[] aliases;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    protected Charset(String canonicalName, String[] aliases) {
        Charset.checkName(canonicalName);
        if (aliases != null) {
            int n = aliases.length;
            for (int i = 0; i < n; ++i) {
                Charset.checkName(aliases[i]);
            }
        }
        this.canonicalName = canonicalName;
        this.aliases = aliases;
    }

    private static void checkName(String name) {
        int n = name.length();
        if (n == 0) {
            throw new IllegalCharsetNameException(name);
        }
        char ch = name.charAt(0);
        if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9')) {
            throw new IllegalCharsetNameException(name);
        }
        for (int i = 1; i < n; ++i) {
            ch = name.charAt(i);
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '.' || ch == ':' || ch == '_') continue;
            throw new IllegalCharsetNameException(name);
        }
    }

    public static boolean isSupported(String charsetName) {
        return Charset.charsetForName(charsetName) != null;
    }

    public static Charset forName(String charsetName) {
        Charset cs = Charset.charsetForName(charsetName);
        if (cs == null) {
            throw new UnsupportedCharsetException(charsetName);
        }
        return cs;
    }

    private static Charset charsetForName(String charsetName) {
        Charset.checkName(charsetName);
        return Charset.provider().charsetForName(charsetName);
    }

    public static SortedMap availableCharsets() {
        TreeMap charsets = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Iterator i = Charset.provider().charsets();
        while (i.hasNext()) {
            Charset cs = (Charset)i.next();
            charsets.put(cs.name(), cs);
        }
        return Collections.unmodifiableSortedMap(charsets);
    }

    private static final CharsetProvider provider() {
        return Provider.provider();
    }

    public final String name() {
        return this.canonicalName;
    }

    public final Set aliases() {
        if (this.aliases == null) {
            return Collections.EMPTY_SET;
        }
        int n = this.aliases.length;
        HashSet aliasSet = new HashSet(n);
        for (int i = 0; i < n; ++i) {
            aliasSet.add(this.aliases[i]);
        }
        return Collections.unmodifiableSet(aliasSet);
    }

    public String displayName() {
        return this.canonicalName;
    }

    public String displayName(Locale locale) {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        return this.canonicalName.startsWith("x-") ^ true && this.canonicalName.startsWith("X-") ^ true;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final ByteBuffer encode(CharBuffer cb) {
        try {
            Class clazz = Charset.class$("java.nio.charset.Charset");
            synchronized (clazz) {
                try {
                    if (cachedEncoder == null) {
                        cachedEncoder = this.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                    }
                    ByteBuffer byteBuffer = cachedEncoder.encode(cb);
                    Object var4_4 = null;
                    return byteBuffer;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final ByteBuffer encode(String str) {
        return this.encode(CharBuffer.wrap(str));
    }

    public CharBuffer decode(ByteBuffer bb) {
        try {
            Class clazz = Charset.class$("java.nio.charset.Charset");
            synchronized (clazz) {
                try {
                    if (cachedDecoder == null) {
                        cachedDecoder = this.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                    }
                    CharBuffer charBuffer = cachedDecoder.decode(bb);
                    Object var4_4 = null;
                    return charBuffer;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final int compareTo(Object ob) {
        return this.canonicalName.compareToIgnoreCase(((Charset)ob).canonicalName);
    }

    public final int hashCode() {
        return this.canonicalName.hashCode();
    }

    public final boolean equals(Object ob) {
        if (ob instanceof Charset) {
            return this.canonicalName.equalsIgnoreCase(((Charset)ob).canonicalName);
        }
        return false;
    }

    public final String toString() {
        return this.canonicalName;
    }

    static {
        Class clazz = Charset.class$("java.nio.charset.Charset");
        synchronized (clazz) {
            try {
                cachedEncoder = null;
                cachedDecoder = null;
            }
            finally {
                Object var1_1 = null;
            }
            return;
        }
    }
}

