/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.ShortBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public abstract class ShortBuffer
extends Buffer
implements Comparable {
    protected short[] backing_buffer;
    protected int array_offset = 0;

    public static ShortBuffer allocateDirect(int capacity) {
        throw new Error("direct buffers not implemented");
    }

    public static ShortBuffer allocate(int capacity) {
        return new ShortBufferImpl(capacity, 0, capacity);
    }

    public static final ShortBuffer wrap(short[] array, int offset, int length) {
        return new ShortBufferImpl(array, offset, length);
    }

    public static final ShortBuffer wrap(String a) {
        int len = a.length();
        short[] buffer = new short[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = (short)a.charAt(i);
        }
        return ShortBuffer.wrap(buffer, 0, len);
    }

    public static final ShortBuffer wrap(short[] array) {
        return ShortBuffer.wrap(array, 0, array.length);
    }

    ShortBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }

    public ShortBuffer get(short[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public ShortBuffer get(short[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ShortBuffer put(ShortBuffer src) {
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public ShortBuffer put(short[] src, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final ShortBuffer put(short[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final short[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object ob) {
        ShortBuffer a = (ShortBuffer)ob;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = this.get(i1) - a.get(i2);
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer compact();

    public abstract boolean isDirect();

    public abstract ShortBuffer slice();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();
}

