/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;

public class ServerSocket {
    private static SocketImplFactory factory;
    private SocketImpl impl;
    private ServerSocketChannel ch;
    private boolean closed;

    private /* synthetic */ void finit$() {
        this.closed = false;
    }

    public ServerSocket() throws IOException {
        this.finit$();
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
        this.impl.create(true);
    }

    public ServerSocket(int port) throws IOException {
        this(port, 50);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this();
        if (this.impl == null) {
            throw new IOException("Cannot initialize Socket implementation");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(port);
        }
        if (bindAddr == null) {
            bindAddr = InetAddress.ANY_IF;
        }
        this.impl.create(true);
        this.impl.bind(bindAddr, port);
        this.impl.listen(backlog);
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 50);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (this.closed) {
            throw new SocketException("ServerSocket is closed");
        }
        if (this.impl == null) {
            throw new IOException("Cannot initialize Socket implementation");
        }
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address type not supported");
        }
        InetSocketAddress tmp = (InetSocketAddress)endpoint;
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(tmp.getPort());
        }
        this.impl.bind(tmp.getAddress(), tmp.getPort());
        this.impl.listen(backlog);
    }

    public InetAddress getInetAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException e) {
            return null;
        }
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        InetAddress addr = this.getInetAddress();
        if (addr != null) {
            return new InetSocketAddress(this.getInetAddress(), this.getLocalPort());
        }
        return null;
    }

    public Socket accept() throws IOException {
        if (this.impl == null) {
            throw new IOException("Cannot initialize Socket implementation");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkListen(this.impl.getLocalPort());
        }
        Socket s = new Socket();
        this.implAccept(s);
        return s;
    }

    protected final void implAccept(Socket s) throws IOException {
        if (this.ch != null && !this.ch.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        this.impl.accept(s.impl);
    }

    public void close() throws IOException {
        if (this.impl != null) {
            this.impl.close();
        }
        if (this.ch != null) {
            this.ch.close();
        }
        this.closed = true;
    }

    public ServerSocketChannel getChannel() {
        return this.ch;
    }

    public boolean isBound() {
        try {
            Object bindaddr = this.impl.getOption(15);
        }
        catch (SocketException e) {
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public int getSoTimeout() throws IOException {
        Object timeout = this.impl.getOption(4102);
        if (!(timeout instanceof Integer)) {
            throw new IOException("Internal Error");
        }
        return (Integer)timeout;
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        this.impl.setOption(4, new Boolean(on));
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        Object reuseaddr = this.impl.getOption(4);
        if (!(reuseaddr instanceof Boolean)) {
            throw new SocketException("Internal Error");
        }
        return (Boolean)reuseaddr;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("SO_RCVBUF value must be > 0");
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Not connected");
        }
        Object buf = this.impl.getOption(4098);
        if (!(buf instanceof Integer)) {
            throw new SocketException("Internal Error: Unexpected type");
        }
        return (Integer)buf;
    }

    public String toString() {
        return "ServerSocket" + this.impl.toString();
    }

    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        factory = fac;
    }
}

