/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.SourceError;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SourceMessages {
    private int errorCount = 0;
    SourceError firstError;
    SourceError lastError;
    SourceError lastPrevFilename = null;

    public boolean checkErrors(PrintStream printStream, int n) {
        if (this.firstError != null) {
            this.printAll(printStream, n);
            this.lastError = null;
            this.firstError = null;
            int n2 = this.errorCount;
            this.errorCount = 0;
            return n2 > 0;
        }
        return false;
    }

    public boolean checkErrors(PrintWriter printWriter, int n) {
        if (this.firstError != null) {
            this.printAll(printWriter, n);
            this.lastError = null;
            this.firstError = null;
            int n2 = this.errorCount;
            this.errorCount = 0;
            return n2 > 0;
        }
        return false;
    }

    public void clearErrors() {
        this.errorCount = 0;
    }

    public void error(char c, String string, int n, int n2, String string2) {
        this.error(new SourceError(c, string, n, n2, string2));
    }

    public void error(SourceError sourceError) {
        SourceError sourceError2;
        if (sourceError.severity == 'f') {
            this.errorCount = 1000;
        } else if (sourceError.severity != 'w') {
            ++this.errorCount;
        }
        if (this.lastError != null && this.lastError.filename != null && !this.lastError.filename.equals(sourceError.filename)) {
            this.lastPrevFilename = this.lastError;
        }
        SourceError sourceError3 = this.lastPrevFilename;
        while ((sourceError2 = sourceError3 == null ? this.firstError : sourceError3.next) != null && (sourceError.line == 0 || sourceError2.line == 0 || sourceError.line >= sourceError2.line && (sourceError.line != sourceError2.line || sourceError.column == 0 || sourceError2.column == 0 || sourceError.column >= sourceError2.column))) {
            sourceError3 = sourceError2;
        }
        if (sourceError3 == null) {
            sourceError.next = this.firstError;
            this.firstError = sourceError;
        } else {
            sourceError.next = sourceError3.next;
            sourceError3.next = sourceError;
        }
        if (sourceError3 == this.lastError) {
            this.lastError = sourceError;
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public SourceError getErrors() {
        return this.firstError;
    }

    void printAll(PrintStream printStream, int n) {
        SourceError sourceError = this.firstError;
        while (sourceError != null && --n >= 0) {
            printStream.println(sourceError);
            sourceError = sourceError.next;
        }
    }

    void printAll(PrintWriter printWriter, int n) {
        SourceError sourceError = this.firstError;
        while (sourceError != null && --n >= 0) {
            printWriter.println(sourceError);
            sourceError = sourceError.next;
        }
    }

    public boolean seenErrors() {
        return this.errorCount > 0;
    }

    public String toString(int n) {
        if (this.firstError == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        SourceError sourceError = this.firstError;
        while (sourceError != null && --n >= 0) {
            stringBuffer.append(sourceError);
            stringBuffer.append('\n');
            sourceError = sourceError.next;
        }
        return stringBuffer.toString();
    }
}

