/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import java.util.Hashtable;

public abstract class Type {
    String signature;
    String this_name;
    int size;
    static Hashtable mapClassToType;
    static Hashtable mapNameToType;
    public static final PrimType byte_type;
    public static final PrimType short_type;
    public static final PrimType int_type;
    public static final PrimType long_type;
    public static final PrimType float_type;
    public static final PrimType double_type;
    public static final PrimType boolean_type;
    public static final PrimType char_type;
    public static final PrimType void_type;
    public static final PrimType neverReturnsType;
    public static final ObjectType nullType;
    public static ClassType pointer_type;
    public static ClassType string_type;
    public static ClassType boolean_ctype;
    public static ClassType throwable_type;
    public static Type[] typeArray0;
    public static Method toString_method;
    public static ClassType number_type;
    public static Method intValue_method;
    public static Method longValue_method;
    public static Method floatValue_method;
    public static Method doubleValue_method;
    public static Method booleanValue_method;
    protected Class reflectClass;

    static {
        byte_type = new PrimType("byte", "B", 1, Byte.TYPE);
        short_type = new PrimType("short", "S", 2, Short.TYPE);
        int_type = new PrimType("int", "I", 4, Integer.TYPE);
        long_type = new PrimType("long", "J", 8, Long.TYPE);
        float_type = new PrimType("float", "F", 4, Float.TYPE);
        double_type = new PrimType("double", "D", 8, Double.TYPE);
        boolean_type = new PrimType("boolean", "Z", 1, Boolean.TYPE);
        char_type = new PrimType("char", "C", 2, Character.TYPE);
        void_type = new PrimType("void", "V", 0, Void.TYPE);
        neverReturnsType = new PrimType("(never-returns)", "V", 0, Void.TYPE);
        nullType = new ObjectType("(type of null)");
        pointer_type = ClassType.make("java.lang.Object");
        string_type = ClassType.make("java.lang.String");
        boolean_ctype = ClassType.make("java.lang.Boolean");
        throwable_type = ClassType.make("java.lang.Throwable");
        typeArray0 = new Type[0];
        toString_method = pointer_type.addMethod("toString", typeArray0, string_type, 1);
        number_type = ClassType.make("java.lang.Number");
        intValue_method = number_type.addMethod("intValue", typeArray0, int_type, 1);
        longValue_method = number_type.addMethod("longValue", typeArray0, long_type, 1);
        floatValue_method = number_type.addMethod("floatValue", typeArray0, float_type, 1);
        doubleValue_method = number_type.addMethod("doubleValue", typeArray0, double_type, 1);
        booleanValue_method = boolean_ctype.addMethod("booleanValue", typeArray0, boolean_type, 1);
    }

    Type() {
    }

    Type(String nam, String sig) {
        this.this_name = nam;
        this.signature = sig;
    }

    public abstract Object coerceFromObject(Object var1);

    public Object coerceToObject(Object obj) {
        return obj;
    }

    public abstract int compare(Type var1);

    public void emitCoerceFromObject(CodeAttr code) {
        throw new Error("unimplemented emitCoerceFromObject for " + this);
    }

    public void emitCoerceToObject(CodeAttr code) {
    }

    public void emitIsInstance(CodeAttr code) {
        code.emitInstanceof(this);
    }

    public final String getName() {
        return this.this_name;
    }

    public Class getReflectClass() {
        return this.reflectClass;
    }

    public final String getSignature() {
        return this.signature;
    }

    public final int getSize() {
        return this.size;
    }

    public static Type getType(String name) {
        Type type = Type.lookupType(name);
        if (type == null) {
            if (name.endsWith("[]")) {
                type = Type.getType(name.substring(0, name.length() - 2));
                type = new ArrayType(type, name);
            } else {
                ClassType cl = new ClassType(name);
                try {
                    cl.reflectClass = Class.forName(name);
                    cl.flags |= 4;
                }
                catch (ClassNotFoundException classNotFoundException) {}
                type = cl;
            }
            mapNameToType.put(name, type);
        }
        return type;
    }

    public boolean isInstance(Object obj) {
        return this.getReflectClass().isInstance(obj);
    }

    public static boolean isMoreSpecific(Type[] t1, Type[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        int i = t1.length;
        while (--i >= 0) {
            if (t1[i].isSubtype(t2[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean isSubtype(Type other) {
        int comp = this.compare(other);
        return comp == -1 || comp == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidJavaTypeName(String name) {
        boolean in_name = false;
        int len = name.length();
        while (len > 2 && name.charAt(len - 1) == ']' && name.charAt(len - 2) == '[') {
            len -= 2;
        }
        int i = 0;
        while (i < len) {
            char ch = name.charAt(i);
            if (ch == '.') {
                if (!in_name) return false;
                in_name = false;
            } else {
                if (!(in_name ? Character.isJavaIdentifierPart(ch) : Character.isJavaIdentifierStart(ch))) return false;
                in_name = true;
            }
            ++i;
        }
        if (i == len) return true;
        return false;
    }

    public final boolean isVoid() {
        return this.size == 0;
    }

    public static Type lookupType(String name) {
        if (mapNameToType == null) {
            mapNameToType = new Hashtable();
            mapNameToType.put("byte", byte_type);
            mapNameToType.put("short", short_type);
            mapNameToType.put("int", int_type);
            mapNameToType.put("long", long_type);
            mapNameToType.put("float", float_type);
            mapNameToType.put("double", double_type);
            mapNameToType.put("boolean", boolean_type);
            mapNameToType.put("char", char_type);
            mapNameToType.put("void", void_type);
        }
        return (Type)mapNameToType.get(name);
    }

    public static Type lowestCommonSuperType(Type t1, Type t2) {
        if (t1 == neverReturnsType) {
            return t2;
        }
        if (t2 == neverReturnsType) {
            return t1;
        }
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1.isSubtype(t2)) {
            return t2;
        }
        if (t2.isSubtype(t1)) {
            return t1;
        }
        if (!(t1 instanceof ClassType) || !(t2 instanceof ClassType)) {
            return null;
        }
        ClassType c1 = (ClassType)t1;
        ClassType c2 = (ClassType)t2;
        if (c1.isInterface()) {
            return pointer_type;
        }
        if (c2.isInterface()) {
            return pointer_type;
        }
        return Type.lowestCommonSuperType(c1.getSuperclass(), c2.getSuperclass());
    }

    public static Type make(Class reflectClass) {
        Type type;
        Object t;
        if (mapClassToType != null && (t = mapClassToType.get(reflectClass)) != null) {
            return (Type)t;
        }
        if (reflectClass.isArray()) {
            type = ArrayType.make(Type.make(reflectClass.getComponentType()));
        } else {
            if (reflectClass.isPrimitive()) {
                throw new Error("internal error - primitive type not found");
            }
            String name = reflectClass.getName();
            type = Type.lookupType(name);
            if (type == null) {
                ClassType cl = new ClassType(name);
                cl.flags |= 4;
                type = cl;
                mapNameToType.put(name, type);
            }
            if (reflectClass.isInterface()) {
                ((ClassType)type).access_flags |= 0x200;
            }
        }
        type.reflectClass = reflectClass;
        Type.registerTypeForClass(reflectClass, type);
        return type;
    }

    public Type promote() {
        return this.size < 4 ? int_type : this;
    }

    public static void registerTypeForClass(Class clas, Type type) {
        if (mapClassToType == null) {
            mapClassToType = new Hashtable(100);
        }
        mapClassToType.put(clas, type);
        type.reflectClass = clas;
    }

    protected void setSignature(String sig) {
        this.signature = sig;
    }

    public static int signatureLength(String sig) {
        return Type.signatureLength(sig, 0);
    }

    public static int signatureLength(String sig, int pos) {
        int end;
        int len = sig.length();
        if (len <= pos) {
            return -1;
        }
        char c = sig.charAt(pos);
        int arrays = 0;
        while (c == '[') {
            ++arrays;
            c = sig.charAt(++pos);
        }
        if (Type.signatureToPrimitive(c) != null) {
            return arrays + 1;
        }
        if (c == 'L' && (end = sig.indexOf(59, pos)) > 0) {
            return arrays + end + 1 - pos;
        }
        return -1;
    }

    public static String signatureToName(String sig) {
        Type type;
        int len = sig.length();
        if (len == 0) {
            return null;
        }
        char c = sig.charAt(0);
        if (len == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type.getName();
        }
        if (c == '[') {
            int arrays = 1;
            if (arrays < len && sig.charAt(arrays) == '[') {
                ++arrays;
            }
            if ((sig = Type.signatureToName(sig.substring(arrays))) == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer(50);
            buf.append(sig);
            while (--arrays >= 0) {
                buf.append("[]");
            }
            return buf.toString();
        }
        if (c == 'L' && len > 2 && sig.indexOf(59) == len - 1) {
            return sig.substring(1, len - 1).replace('/', '.');
        }
        return null;
    }

    public static Type signatureToPrimitive(char sig) {
        switch (sig) {
            case 'B': {
                return byte_type;
            }
            case 'C': {
                return char_type;
            }
            case 'D': {
                return double_type;
            }
            case 'F': {
                return float_type;
            }
            case 'S': {
                return short_type;
            }
            case 'I': {
                return int_type;
            }
            case 'J': {
                return long_type;
            }
            case 'Z': {
                return boolean_type;
            }
            case 'V': {
                return void_type;
            }
        }
        return null;
    }

    public static Type signatureToType(String sig) {
        return Type.signatureToType(sig, 0, sig.length());
    }

    public static Type signatureToType(String sig, int off, int len) {
        Type type;
        if (len == 0) {
            return null;
        }
        char c = sig.charAt(off);
        if (len == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type;
        }
        if (c == '[') {
            type = Type.signatureToType(sig, off + 1, len - 1);
            return type == null ? null : new ArrayType(type);
        }
        if (c == 'L' && len > 2 && sig.indexOf(59, off) == len - 1 + off) {
            return ClassType.make(sig.substring(off + 1, len - 1 + off).replace('/', '.'));
        }
        return null;
    }

    protected static int swappedCompareResult(int code) {
        return code == 1 ? -1 : (code == -1 ? 1 : code);
    }

    public String toString() {
        return "Type " + this.getName();
    }
}

