// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Objective C interface to Raster, for use with libtclobjc

#import <swarmgraph/Widget.h>
#import <swarmgraph/AColormap.h>
#ifdef _TK_
#import <tk.h>
#import <tkobjc/XColormap.h>
#import <tkobjc/XDrawer.h>
#else
#import <swarmgraph/Drawer.h>
#import <swarmgraph/java.h>
#endif

#define ButtonLeft 1
#define ButtonMiddle 2
#define ButtonRight 3

// this could include a list of environments (graphics contexts)
@interface Raster : Widget {
  unsigned width, height;
  id button1Client, button2Client, button3Client;
  SEL button1Sel, button2Sel, button3Sel;
#ifdef _TK_
  Tk_Window tkwin;
  Display * display;
  Window xwin;
  GC gc;
  Pixmap pm;
#else
  id canvas;		// encapsulates Java object on which we draw
  AColormap * colormap; // our color mape
  PixelValue * map;
#endif
}

#ifdef _TK_
-(Display *) getDisplay;
-draw: (id <XDrawer>) xd X: (int) x Y: (int) y;
#else
-draw: (id <Drawer>) xd X: (int) x Y: (int) y;
#endif

-(AColormap *) getColormap;
-setColormap: (AColormap *) colormap;

-drawPointX: (int) x Y: (int) y Color: (Color) c;
-fillRectangleX0: (int) x0 Y0: (int) y0 X1: (int) x1 Y1: (int) y1 Color: (Color) c;
-drawSelf;
-erase;
-handleButton: (int) n X: (long) x Y: (long) y;
-setButton: (int) n Client: c Message: (SEL) s;
@end
