
#ifndef _JAVA_OBJECT_H
#define _JAVA_OBJECT_H
/*
 *  JavaObject:  encapsulate some random java object and provide some
 *  simple, common access to methods on that object
 */

#include "JavaClass.h"

@interface JavaObject : Object {
  JNIEnv * env;
  id classid;		/* this object's class */ 
  jobject this;		/* this object */
}

+ new: (id) _classid : (jobject) _this;

- init: (id) _classid : (jobject) _this;

- (jint) callIntMethod: (jmethodID) id;

- (void) callVoidMethod: (jmethodID) id;
- (void) callVoidMethod: (jmethodID) id : (int)val1;
- (void) callVoidMethod: (jmethodID) id : (int)val1 : (int)val2;
- (void) callVoidMethod: (jmethodID) id : (int)val1 
		       : (int)val2 : (int)val3;
- (void) callVoidMethod: (jmethodID) id : (int)val1 
		       : (int)val2 : (int)val3 : (int)val4;
- (void) callVoidMethod: (jmethodID) id : (int)val1 
		       : (int)val2 : (int)val3 : (int)val4 
		       : (int)val5;

@end

#endif

