//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            NormalDistribution.h
Description:     Normal (Gaussian) distribution returning double values
Library:         random
Original Author: Manor Askenazi
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/


#import <random/RandomDefs.h>
#import <random/ProbabilityDistribution.h>

@interface NormalDistribution: ProbabilityDistribution //<Normal>

{

// Parameters:

   double theMean;
   double theVariance;
   double theStdDev;

// Working variables:

   BOOL stored;
   double stored_double;

}

// Methods that conform to the Normal protocol:

+create: aZone setGenerator: generator
	setMean: (double) mean setVariance: (double) variance;

-(void) setMean: (double) mean setVariance: (double) variance;

-(double) getMean;
-(double) getVariance;
-(double) getStdDev;

-(double) getSampleWithMean: (double) mean withVariance: (double) variance;

// Methods that conform to the DoubleDistribution protocol:

-(double) getDoubleSample;

// Methods that override superclass methods:

// -(void) getState: (void *) state;
// -(void) setState: (void *) state;

// -initState;
// -resetState;

@end
