//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            LCG3gen.h
Description:     Linear Congruential Generator
Library:         random
Original Author: Nelson Minar
Date:            1996-09-09
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

// This generator returns successive pseudo-random UNSIGNED INTEGERS
// in the closed interval [0, 2^32-1]:

// The algorithm is from Knuth vol. II.

// Constants chosen from the table in Knuth vol II p.102.
// The multiplier is from line 26 of the table.

#define LCG3MULTIPLIER     1664525U
#define LCG3ADDER        152193325U

// Knuth claims that the adder c does not really matter as long as it
// doesn't have factors in common with the modulus (2^32). The above value
// is the one used in the internal LCG generator used by SWBx. 

#import <random/RandomNumberGenerator.h>


@interface LCG3: RandomNumberGenerator

{

// Parameters:

   unsigned a;		// multiplier
   unsigned c;		// additive term

// Data objects (state variables):

   unsigned state;	// vector of lagged values (state vector)

}

// The following RandomNumberGenerator methods are overridden:

// -initState;
// -resetState;

// -(void) getState: (void *) stateBuf;
// -(void) setState: (void *) stateBuf;

// -(unsigned) getUnsignedSample;

@end
