//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            GammaDistribution.h
Description:     Gamma distribution returning double values
Library:         random
Original Author: Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/


#import <random/RandomDefs.h>
#import <random/ProbabilityDistribution.h>

@interface GammaDistribution: ProbabilityDistribution //<Gamma>

{

// Parameters:

   double theAlpha;
   double theBeta;

// Working variables:


}

// Methods that conform to the Gamma protocol:

+create: aZone setGenerator: generator
	setAlpha: (double) alpha setBeta: (double) beta;

-(void) setAlpha: (double) alpha setBeta: (double) beta;

-(double) getAlpha;
-(double) getBeta;

-(double) getSampleWithAlpha: (double) alpha withBeta: (double) beta;

// Methods that conform to the DoubleDistribution protocol:

-(double) getDoubleSample;

// Methods that override superclass methods:

// -(void) getState: (void *) state;
// -(void) setState: (void *) state;

// -initState;
// -resetState;

@end
