// Market application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <swarmobject.h>

@interface MarketModelSwarm : Swarm {
  int numPredictors;
  double accuracyUpdateRate;
  double discountRate;
  double dividendJumpScale;
  
  id modelActions;
  id modelSchedule;

  id aMarket;
}

-(double) getPrice;
-(double) getDividend;
-(double) getFundamental;
-(int *) getPredictorUse;

+createBegin: (id) aZone;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end
