// Hello, World! application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// This is the header file for the Person agent.  It defines the 
// instance variables and everything else the Person needs to work
// in the world.

// include the space declarations
#import <space.h>
#import <tkobjc/Raster.h>
#import <collections/String.h>

// this is the space agent superclass
#import "Agent2d.h"

// define a type to help index conversation subjects
typedef enum { 
  null = 0,       // no topic
  hello = 1,      // say hello
} topic_type;


// define the methods a person can execute  These are defined in 
// Person.m
@interface Person: Agent2d {

  id pplPresent;  // the list of people at the party
  id room;    // the space in which the party takes place
  id party;   // the pointer back to the model swarm (party host)
  float topics[2];
  int value;
  id name;  // person's name
  id listOfFriends; // people I've talked to
  int stillhere;  // used for rolecall
  int showSpeech;  // flag for printing speech to the screen (0 by default)
  Color myColor;

  Person * target;
  int approachingTarget;


}

// move one time step forward
-step;

// set the environment up so that the agent can receive sensory input
-setWorld: (id) l Room: (id) r Party: (id) m;

// set the agent up with the parameters given
-setPerson: (id) n 
Topic_array: (float *) t 
ShowSpeech: (int) sp ;

-setPersonColor: (Color) c;
// get the person's name
-(char *) getName;

// print info about the person
-print;

// say something to somebody
-speak: (topic_type) topic ToPerson: (id) target;

// look around for someone to talk to
-look;

// decide to stay or go
- (char *) stayOrGo;

// provide this method so that the average graph can operate
- (int) getNumFriends;

// customized createEnd to instantiate any special variables
- createEnd;

@end
