// Hello, World! application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// This is the method definitions file for the Person agents.

// include simtools so we can use the random number library
#import <simtools.h>
// include person header so that everything will be defined
#import "Person.h"
#import "PplModelSwarm.h"
@implementation Person

-step {
  value += 1;
  if (!strcmp([self stayOrGo],"stay"))
    [self look];
  else
    [party ImFinished];
  return self;
}

-setWorld: (id) l Party: (id) m {
  world = l;   // set a pointer inside each party-goer to the list of partiers
  party = m;   // set a pointer inside each party-goer for the id of the party
  return self;
}

-setPerson: (id) n Topic_array: (float *) t {
  int i;

  name = n;
  value = 0;
  for (i=0;i<2;i++) {
    topics[i] = t[i];
  }
  stillhere = 1;   // always here when initialized
  return self;
}

-print {
  int inci;

  (void) printf("\t Step value = %d\n", value);
  (void) printf("%s%f\n%s%f\n",
		"\t              topics[null] = ", topics[null],
		"\t             topics[hello] = ", topics[hello]);

  (void) printf("\tMy name is %s\n",[self getName]);
  (void) printf("\t\tMy list of friends is %d long:\n",
		[listOfFriends getCount]);
  for (inci=0;inci<[listOfFriends getCount]; inci++)
     (void) printf("\t\t\t%s\n",[[listOfFriends atOffset: inci] getName]);


  return self;
}

- (char *) getName {
  return [name getC];
}

-speak: (topic_type) topic ToPerson: (id) person {
  float new_topic_num;
  // topic can be null
  new_topic_num = (float)[uniformDblRand getDoubleWithMin: 0.0L withMax: 1.0L];

  if (new_topic_num < topics[null])
    (void) printf("Prefer to talk about nothing with ");
  else if (new_topic_num < topics[hello])
    (void) printf("%s says Hello, ", [self getName]);
  else {
    (void) fprintf(stderr,"Exception in random topic draw.\n");
    exit(-1);
  }

  (void) printf(" to %5s.\n", [person getName]);

  return self;
}

-(Person *) look {
  id tgt;
  id indx;         // index for persons
  int numfriends, inci, talked = 0;

  // look over the whole world and see if there's anyone I haven't
  //   talked to yet
  tgt = [world atOffset: [uniformIntRand getIntegerWithMin: 0L withMax: ([world getCount]-1)]];

  // decide if you've already talked to that person
  // if the count is > zero, there are friends in the list
  if ((numfriends = [listOfFriends getCount]) > 0) {
    // loop through the people we've talked to already
    for (inci = 0; inci < numfriends; inci++) {
      // linked list elements accessed via an offset from 0
      indx = [listOfFriends atOffset: inci];
      // if this friend's id is the same as my target's id, then
      // I've already talked to her
      if (tgt == indx)
	talked = 1;
    }
  }

  // if we don't have her listed, then say hi
  if (!talked) {
    // go ahead and say hi
    [self speak: hello ToPerson: tgt];
    // then put that person in your list of friends
    [listOfFriends addLast: tgt];
  }
  return self;
}

- (char *) stayOrGo {
  if (stillhere) {
    // see if you've talked to everybody
    if ([world getCount] == [listOfFriends getCount])
      stillhere = 0;
  }
  return (stillhere == 1 ? "stay" : "gone");
}

- createEnd {
  // create an empty list in which to put the people you will talk to
  listOfFriends = [List create: [self getZone]];

  // do the super's createEnd for switcheroo (not strictly necessary)
  [super createEnd];
  return self;
}
@end
