#import "grid.h"
#import <activity.h>
#import <activity/SwarmProcess.h>
#import <objectbase/Swarm.h>
#import <objectbase.h>
#include <misc.h>

static void testTerminate( timeval_t terminateTime )
{
  if ( getCurrentTime() >= terminateTime )
    [getTopLevelActivity() terminate];
}

@interface MySwarm: Swarm
{
  int  myVar;
}
- (void) setMyVar: (int)value;
- (void) printMyVar;
@end

@implementation MySwarm

- (void) setMyVar: (int)value
{
  myVar = value;
}

- (void) printMyVar
{
  printf( "value is %d\n", myVar );
}

@end

int main(void)
{
  id   aZone, aTurtle;
  id   simSched1, action1, action2, action3, moveGroup;
  id   simSched2, displaySchedule, terminateSchedule;
  id   displaySwarm, simSwarm;
  id   <Activity>swarmActivity;

  // initialize

  initModule( grid );
  initModule( activity );

  aZone = [Zone create: globalZone];
  displaySwarm = [Swarm create: aZone];
  simSwarm = [MySwarm create: displaySwarm];
  _activity_zone = [Zone create: globalZone];

  // create a turtle to turn and move during simulation

  aTurtle = [GridTurtle create: simSwarm];

  // create a pair of simulation schedules (repeat intervals of 2 and 4)

  simSched1 = [Schedule createBegin: simSwarm];
  [simSched1 setRepeatInterval: 2];
  simSched1 = [simSched1 createEnd];
  action1 = [simSched1 at: 0 createActionTo: aTurtle message: M(move:):(id)10];
  moveGroup = [ActionGroup create: simSwarm];
  action2 = [moveGroup createActionTo: aTurtle message: M(move:) : (id)-5];
  [simSched1 at: 0 createAction: moveGroup];
  [simSched1 at: 0 createActionCall: (func_t)testTerminate : (id)20];

  simSched2 = [Schedule createBegin: simSwarm];
  [simSched2 setRepeatInterval: 4];
  simSched2 = [simSched2 createEnd];
  [simSched2 at: 0 createActionTo: aTurtle message: M(turn:) : (id)1];
  action3 = [simSched2 at: 0 createActionCall: (func_t)testTerminate : (id)10];

  // create a display schedule to print turtle at every time step

  displaySchedule = [Schedule createBegin: displaySwarm];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule createActionTo: aTurtle message: M(print)];

  // create a schedule to terminate after a while

  terminateSchedule = [Schedule create: displaySwarm];
  [terminateSchedule at: 10
    createActionTo: moveGroup message: M(remove:) : action2];
  [terminateSchedule at: 4
    createActionTo: simSched2 message: M(remove:) : action3];
  [terminateSchedule at: 16 createActionCall: (func_t)testTerminate : (id)16];

  // activate top-level swarm

  swarmActivity = [displaySwarm activateIn: nil];

  // manipulate custom swarm and then activate it

  [simSwarm setMyVar: 99];
  [simSwarm printMyVar];

  [simSwarm activateIn: displaySwarm];
  [[[simSwarm getSwarmActivity] getSwarm] printMyVar];

  // activate simulation schedules in simulation swarm

  [simSched1 activateIn: simSwarm];
  [simSched2 activateIn: simSwarm];

  // activate display schedules to mix in with simulation swarm

  [displaySchedule activateIn: displaySwarm];
  [terminateSchedule activateIn: displaySwarm];

  // run the top-level swarm to completion

  while ( [swarmActivity next] != Completed );

  [swarmActivity drop];
  [_activity_zone xprint];
  return 0;
}
