#import "grid.h"

#define __USE_FIXED_PROTOTYPES__   // for gcc headers
#include <stdio.h>

int main(void)
{
  id   aZone, anArray, aTurtle, aMember, index;
  int  i;
  
  initModule( grid );

  aZone = [Zone create: globalZone];

  anArray = [Array createBegin: aZone];
  [anArray setCount: 12];
  [anArray setDefaultMember: Member];
  anArray = [anArray createEnd];

  printf( "count: %d\n", [anArray getCount] );

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: aZone];
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    [anArray atOffset: i put: aTurtle];
  }

  printf( "count: %d\n", [anArray getCount] );

  index = [anArray begin: scratchZone];
  while ( (aMember = [index next]) ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }
  while ( (aMember = [index prev]) ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }

  [anArray setCount: 15];
  index = [anArray begin: scratchZone];
  while ( (aMember = [index next]) ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }
  [index setLoc: Start];

  [anArray setCount: 8];
  index = [anArray begin: scratchZone];
  while ( (aMember = [index next]) ) {
    if ( ! aMember ) {
      printf( "member is nil\n" );
    } else if ( [aMember respondsTo: M(print)] ) {
      [aMember print];
    } else {
      printf( "%s\n", [aMember getName] );
    }
  }

  for ( i = 0; i < 8; i++ ) {
    [[anArray atOffset: i] print];
  }
  [anArray xprint];
  [anArray drop];
  [aZone xprint];
  [aZone drop];
  exit(0);
}
