// Intrinsic.m

// Copyright  1996-2000 Swarm Development Group.
// No warranty implied, see LICENSE for terms.

#import "Intrinsic.h"

@implementation Intrinsic

// initialize the data, that is the 5 basic intrinsic parameters
-initialize:(float) lens: (float)Ku: (float)Kv: (int)U_0: (int)V_0
{
  f = lens;
  ku = Ku;
  kv = Kv;
  u0 = U_0;
  v0 = V_0;
  return self;
}

// send parameters
-(float)sendf
{
  return f;
}

-(float)sendku
{
  return ku;
}

-(float)sendkv
{ 
  return kv;
}

-(int)sendu0
{
  return u0;
}

-(double)sendv0
{
  return v0;
}

// modify parameters

-modifyf: (float)newf
{
  f=newf;
  return self;
}

-modifyku: (float)newku
{
  ku=newku;
  return self;
}

-modifykv: (float)newkv
{
  kv=newkv;
  return self;
}

-modifyu0: (int)newu0
{
  u0=newu0;
  return self;
}

-modifyv0: (int)newv0
{
  v0=newv0;
  return self;
}

// to know the view angle of camera, once initialized. 
// computes the view angle of the camera, given its parameters
-(double)ViewAngle
{
  double angle;

  angle = atan2((double)v0, (double)(kv*f));
  angle = (2*angle*180)/M_PI; // to have it in degrees
  printf("Camera view angle: %g (in degrees)\n", angle);
  return angle;
}

// print intrinsic parameters of camera
-print
{
  printf("Intrinsic parameters of Camera:\nlens: %f, (ku, kv): (%f, %f), (u0, v0): (%d, %d)\n", f, ku, kv, u0, v0);
  return self;
}

@end
