// AgentModelSwarm.h
// swarm room 1996

#import <objectbase/Swarm.h>
#import <space.h>
#import <activity.h>
#import <collections.h>

#import "village.h"
#import "Agent.h"
#import "Cell.h"
#import "DataBase.h"

// the swarm
@interface AgentModelSwarm: Swarm
{
  int allAgents;				  // total num agents overall
  int which_yield;
  int random_yield;
  int time;					  // world time
  int worldXSize, worldYSize;

  id modelActions;                                // scheduling data structures
  id modelSchedule;
  
  // the simulation objects
  id agentList;					  // set of players
  id cellList;					  // set of cells in grid2d
  id database;
  id <Grid2d> world;
}

// creation stuff
+ createBegin: aZone;                             // extra methods you
- createEnd;                                      // provide for Swarms
- buildObjects;
- initWorld;
- initDataBase;
- buildActions;
- activateIn: swarmContext;

// get structures
- getAgentList;                                  // access methods into the
- getCellList;
- (id <Grid2d>)getWorld;                         // model swarm. These methods
- (int)getNumAgents;
- (int)getEstAgents;

// agent additon
- addRandomAgents: (int)num;
- addAgentX: (int)newx Y: (int)newy;
- removeAgents;
- debug;

@end
