// village.h
// 1996 Swarm room
// global stuff 


// AgentObserverSwarm display stuff

#define GRAPH 0


// AgentModelSwarm file for database

#define DATAFILE "./data/year001-025.dat"


// Agent specific stuff

#define wrapX(dx) ( (x+dx+worldX)%worldX)
#define wrapY(dy) ( (y+dy+worldY)%worldY)

#define HOUSE_LIMIT 400         // max n households per cell
#define PLOTS 10                // max plots of .4 ha (about 1 ac) per cell
#define MAIZE_KG_CAL 3560
#define MAIZE_PER    0.6        // prop of diet assumed to come from maize
#define STORAGE_DECR   0.1      // maize decrement year to year in storage

// base are from a season, drawing on Wing & Brown 1979:17-72
#define BASE_CAL_MAN 170820     // 1872 Cal * 91.25 days
#define BASE_CAL_WOM 142350     // 1560 Cal * 91.25 days
#define BASE_CAL_KID 91250      
#define WORK_CAL_MAN 240        // caloric increments per hour work
#define WORK_CAL_WOM 200        // never invoked
#define WORK_CAL_KID 92         // never invoked
#define FALLOW_FACTOR 2
#define ADJUST_FACTOR 3

// Note: VW max harvests are >3 times higher than max harvests
// calculated by Kohler et al. 1986, Orcutt (various) and Wetterstrom, 
// so for comparability purpose we define an adjustment factor allowing
// these to be scaled acccording to earlier estimates. To use Van West's
// estimates, set ADJUST_FACTOR=1; to scale them to be roughly equal to
// earlier estimates, use ADJUST_FACTOR=3. 

// turns on/off some debugging output for agent TAG
#define DEBUG 0
#define TAG 0
