// file: Cell.h
// 10-01-95 the Swarm room
// variables and methods for cell class

#import <swarmobject.h>
#import <space.h>
#import <collections.h>
#import <tkobjc/Raster.h>

#import "village.h"
#import "Agent.h"

@interface Cell : SwarmObject
{
  Grid2d * world; 
  int x,y;					  // coordinates in world
  id settlerSet;				  // set of agents on individual cell
  int display;
  
  int maize_pot;				  // potential natural vegetation
  int water;					  // water info
  int elevation;				  // UTM N & E elevation in m
  int soil;					  // soil type
  
  int farming_plots;				  // num plots used for farming
}

// initialize cell
-setWorld: (Grid2d *) world;
-setX: (int) x Y: (int) y;
-setSettlerSet: (id) settlers;
-createEnd;


// agent manipulation
-addSettler: (id) agent;
-removeSettler: (id) agent;
-probeSettlers;


// set cell state
-setMaizePotential: (int) maize;
-setWaterType: (int) water;
-setElevation: (int) height;
-setSoilType: (int) soil;

// farming info
-setFarmPl: (int) num;
-changeFarmPl: (int) num;


// get cell state
-(id) getSettlerSet;
-(int) getMaizePotential;
-(int) getWaterType;
-(int) getElevation;
-(int) getSoilType;
-(int) getFarmPl;
-(int) getNumHouses;


// for drawing the cell
-setDisplay: (int) what;
-drawSelfOn: (Raster *) r;

// debug
-debugX: (int) inx Y: (int) iny;

@end
