// AgentObserverSwarm.h
// Swarm room 1996

#import <swarmobject.h>
#import <space.h>
#import <activity.h>
#import <tkobjc.h>
#import <collections.h>
#import <simtools.h>
#import <analysis.h>

#import "village.h"
#import "AgentModelSwarm.h"

@interface AgentObserverSwarm : GUISwarm {
  int displayFrequency;				  // one parameter: update freq
  int zoomFactor;				  // display resolution

  id displayActions;				  // schedule data structs
  id displaySchedule;

  AgentModelSwarm * agentModelSwarm;		  // the Swarm we're observing

  // Lots of display objects. First, widgets
  XColormap * colormap;				  // allocate colours
  ZoomRaster * worldRaster;			  // 2d display widget
  EZGraph * avgGraph;			  // graphing widget
  EZGraph * yieldGraph;			  // graphing widget
  EZGraph * popGraph;			  // graphing widget

  // Now, higher order display and data objects
  // Value2dDisplay * heatDisplay;			  // display the heat
  Object2dDisplay * cellDisplay;		  // display the cells
  Object2dDisplay * agentDisplay;		  // display the agents
}

// Methods overriden to make the Swarm.
+createBegin: (id) aZone;

// create the probe maps for objects
+setAgentObserverSwarmProbeMap: (id) aZone;
+setAgentModelSwarmProbeMap: (id) aZone;
+setCellProbeMap: (id) aZone;
+setAgentProbeMap: (id) aZone;

-createEnd;

-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

// display stuff
-(int) displayMaize;
-(int) displayElevation;
-(int) displaySoil;
-(int) displayWater;
-(int) displayElevWater;
-(int) displaySoilWater;

@end
