// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.


#include "BaseCompLrn.h"

#include <math.h>

@implementation BaseCompLrn

//-----------------------------------------------------
//            Learning and recalling functions
//-----------------------------------------------------

//-----------------------------------------------------
-(unsigned ) feedForward: (float *) inpVec {
// dimension should be the same than the input layer

    unsigned i, j, minOp;
    float minVal = 1e12;	// Smallest number around
    memcpy( inpLy, inpVec, inpSize*sizeof(float) );

    for ( i = 0; i < numNeurons; i++ ) {
	opLy[i] = 0;		// Reset output layer
	for ( j = 0; j < inpSize; j++ ) {
	    float dist = Wgts[ i*inpSize + j ] -inpVec[j];
	    opLy[i] += dist*dist;
	}
//	opLy[i] = sqrt( opLy[i] );

	if ( opLy[i] < minVal ) {
	    minOp = i;
	    minVal = opLy[i];
	}
    }
    lastWinner = minOp;		// Instance var, last winning neuron
    return minOp;
}

@end
