/* 
  Link.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  27-SEP-1996


*/



#import "Particle.h"

@class Substrate, Bond;

@interface Link : Particle {
  id bondNorth, bondNorthEast, bondEast, bondSouthEast, 
     bondSouth, bondSouthWest, bondWest, bondNorthWest;
  int bondCount;
  BOOL absorbedSubstrate;
  BOOL disintegrating;
}

+(void) setupProbeMap: (id) aZone;

// Overridden class methods (see doc in Particle.m)

+(void) setClassMobilityFactor: (double) inMobilityFactor;
+(double) getClassMobilityFactor;
+(void) setClassColor: (Color) color;
+(Color) getClassColor;


// Additional Class methods.
+(void) setAbsorbedSubstrateColor: (Color) color;
+(Color) getAbsorbedSubstrateColor;
+(void) setDisintegratingColor: (Color) color;
+(Color) getDisintegratingColor;

+(void) setChainInhibitBondFlag: (BOOL) value;
+(BOOL) getChainInhibitBondFlag;
+(void) setCatInhibitBondFlag: (BOOL) value;
+(BOOL) getCatInhibitBondFlag;

+(void) setDisintegrationProbability: (double) inDisintegrationProbability;
+(double) getDisintegrationProbability;

+(void) setChainInitiateProbability: (double) probability;
+(double) getChainInitiateProbability;
+(void) setChainExtendProbability: (double) probability;
+(double) getChainExtendProbability;
+(void) setChainSpliceProbability: (double) probability;
+(double) getChainSpliceProbability;

+(void) setAbsorptionProbability: (double) inAbsorptionProbability;
+(double) getAbsorptionProbability;

+(void) setEmissionProbability: (double) inEmissionProbability;
+(double) getEmissionProbability;


// Overridden instance method.
-step;
-(BOOL) canMove;
-warp;

// Additional instance methods.

-(int) getBondCount;
-setBond: (Bond *) Bond atNeighbor: (neighbor_t) neighbor;
-(Bond *) getBondAtNeighbor: (neighbor_t) neighbor;

-clearBond: (Bond *) bond;

-doDisintegration;

-attemptBondAtNeighbor: (neighbor_t) neighbor;

/* The following four methods are intended only for 
   interactive use via a probe; they save an interactive
   user having to work out the numeric codes for the 
   directions (which would be necessary to use
   -attemptBondAtNeighbor via a probe); they also
   automatically force an -update on the parentSwarm
   which would be very inefficient if used during normal
   running. */
-attemptBondNorth;
-attemptBondNorthEast;
-attemptBondEast;
-attemptBondSouthEast;
-attemptBondSouth;
-attemptBondSouthWest;
-attemptBondWest;
-attemptBondNorthWest;

-doBonding;


-drawSelfOn: (Raster *) r;

-saveTo: (OutFile *) file;   // Overridden...
-loadFrom: (InFile *) file;  // Overridden...

@end
