/* 
  WorldManager.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  17-OCT-1996

*/

#import <swarmobject.h>
#import <simtools.h>

@interface WorldManager : SwarmObject {
  id probeDisplay;

  unsigned worldTime;
  unsigned prngState;
  unsigned prngCount;
  Color backgroundColor;
}

+createBegin: (id) aZone;
-createEnd;

-step;
-update;

-(unsigned) setWorldTime: (unsigned) time;
-(unsigned) getWorldTime;

-setPRNGstate: (unsigned) newState;
-(unsigned) getPRNGstate;
-setPRNGcount: (unsigned) newCount;
-(unsigned) getPRNGcount;

-setBackgroundColor: (Color) color;
-(Color) getBackgroundColor;

-dropWorld;
-createWorldWithX: (int) xSize Y: (int) ySize;
-createEmptyWorldWithX: (int) xSize Y: (int) ySize;
-createDefaultWorld;

-dropAgent: (id) agent;
-fillWithHoles;
-fillWithSubstrate;
-(int) adjustSubstrateNumberBy: (int) adjustment;
-(int) adjustLinkNumberBy: (int) adjustment;
-(int) adjustCatalystNumberBy: (int) adjustment;

-refreshDisplay;

-saveToFileNamed: (char *) filename;
-loadFromFileNamed: (char *) filename;


@end
