// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* 
  MooreNeighbor.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  08-OCT-1996

  A mooreneighbor can cycle through the values of the
  enumerated type neighbor_t (see Agent2d.h)
  corresponding to the neighbors in the Moore
  neighborhood - i.e.  North, NorthEast, East, SouthEast,
  South, SouthWest, West and NorthWest.

*/

#import <swarmobject.h>

#import "NeighborhoodProtocol.h"
#import "neighbor.h"

@interface MooreNeighbor: SwarmObject

<NeighborhoodProtocol>

/* The -next and -previous methods each rotate the
  given neighbor by 45 degrees.  -next cycles in the
  order North-NorthEast-East-SouthEast-South-SouthWest-
  West-NorthWest; -previous cycles in the reverse order.
*/


@end
