/* 
  Bond.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  01-OCT-1996


*/


#import <swarmobject.h>
#import <simtools.h>
#import <tkobjc/Raster.h>

#import "orientation.h"
#import "Agent.h"

@class Link;

@interface Bond : Agent {
  id link0, link1;
  neighbor_t neighbor0, neighbor1;
  orientation_t orientation;
}

+(void) setClassColor: (Color) color;
+(Color) getClassColor;
+(void) setBondDecayProbability: (double) probability;
+(double) getBondDecayProbability;

-setLink0: (Link *) link;
-(Link *) getLink0;
-setNeighbor0: (neighbor_t) neighbor;
-(neighbor_t) getNeighbor0;


-setLink1: (Link *) link;
-(Link *) getLink1;
-setNeighbor1: (neighbor_t) neighbor;
-(neighbor_t) getNeighbor1;

-setOrientation: (orientation_t) inOrientation;
-(orientation_t) getOrientation;


-clearLinks;

-step;
-drawSelfOn: (Raster *) r;

-(void) drop;

-saveTo: (OutFile *) file;   // Overridden...
-loadFrom: (InFile *) file;  // Overridden...

@end
