// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/* 
  VNneighbor.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  26-SEP-1996

  A vnneighbor can cycle through the values of the enumerated
  type neighbor_t (see Agent2d.h) corresponding to the
  neighbors in the Von Neumann neighborhood - i.e.
  North, East, South, West.

*/

#import <objectbase/SwarmObject.h>

#import "NeighborhoodProtocol.h"
#import "neighbor.h"

@interface VNneighbor: SwarmObject

<NeighborhoodProtocol>

/* The -next and -previous methods each rotate the
  given neighbor by 90 degrees.  -next cycles in the
  order North-East-South-West; -previous cycles in the
  reverse order.
*/


@end
