/* 
  Substrate.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  30-SEP-1996

*/

#import "Substrate.h"

@implementation Substrate


static double substrateMobilityFactor = 1.0;
static Color substrateColor = 1;
/*
  See docs in Particle.m
*/

+(void) setClassMobilityFactor: (double) inMobilityFactor {
  substrateMobilityFactor = inMobilityFactor;
}

+(double) getClassMobilityFactor {
  return(substrateMobilityFactor);
}

+(void) setClassColor: (Color) color {
  substrateColor = color;
}

+(Color) getClassColor {
  return(substrateColor);
}


-drawSelfOn: (Raster *) r {
  int rasterX, rasterY;

  rasterX = (8 * x) + 1;
  rasterY = (8 * y) + 1;

  [r drawPointX: rasterX   Y: rasterY++ Color: particleColor];
  [r drawPointX: rasterX   Y: rasterY++ Color: particleColor];
  [r drawPointX: rasterX++ Y: rasterY   Color: particleColor];
  [r drawPointX: rasterX++ Y: rasterY   Color: particleColor];
  [r drawPointX: rasterX   Y: rasterY-- Color: particleColor];
  [r drawPointX: rasterX   Y: rasterY-- Color: particleColor];
  [r drawPointX: rasterX-- Y: rasterY   Color: particleColor];
  [r drawPointX: rasterX   Y: rasterY   Color: particleColor];

  return self;
}


@end
