/* 
  ParticleManager.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  07-OCT-1996

*/

#import <collections.h>

#import "Particle.h"

#import "ParticleManager.h"

@implementation ParticleManager

-setWorld: (id) inWorld {
  world = inWorld;

  return self;
}


-createEnd {
  if (world == nil)
    [InternalError raiseEvent:
      "ParticleManager object %d not fully initialised before createEnd.\n",
      self];

  return [super createEnd];
}


-(id) createAgent {
  Particle * particle;

  particle = (Particle *) [super createAgent];
  [particle setWorld: world];

  return particle;
}

-dropAgent: (id) agent {
  [agent warp];
  [super dropAgent: agent];

  return self;
}



@end
