/* 
   PRNG.h

   Barry McMullin <mcmullin@eeng.dcu.ie>
   07-Jan-1997
*/

#import <swarmobject.h>
#import <simtools.h>

@interface PRNG: SwarmObject {
  unsigned state;
  unsigned count;
  double doubleRange;
}

// -init; // Overridden.

-createEnd; // Overridden.

-setPRNGstate: (unsigned) newState;
-(unsigned) getPRNGstate;

-setPRNGcount: (unsigned) newCount;
-(unsigned) getPRNGcount;

-saveTo: (OutFile *) file;
-loadFrom: (InFile *) file;

-(unsigned)getPRNGsample;

-(BOOL) getTossWithProb: (double) p;
  /* Return YES with probability p */

-(unsigned) getUniformWithRange: (unsigned) n;
/* Return a value sampled with uniform probability
   on the closed range [0,n-1] */

@end

