// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************
//
// the files ConsumerInterface.h and ProducerInterface.h correspond to the
// file SpecificInterface.h in the master ct-bp code
//
// in SpecificInterface.h we read:
// in apps we have to prepare a XXXInterace.h file for each type of agent:
// in the accompanying ct-hayek application of bp-ct this file corresponds
// to the files ConsumerInterface.h and ProducerInterface.h
//
// **********************************

// ProducerInterface.h 

#import "Interface.h" // see headers imported by Interface.h

@interface ProducerInterface: Interface
{

// we need a variable nX, for each input and a variable nX_out and nX_target
// for each output
// X is the conventional name that we use to identify the specific input
// or output; the use of this kind of variables is explained in the
// related .m file

// +++++++ start
  float  nRevenue0, nProductionStream0, nP0, nQ0,
         nActualP_out   , nActualQ_out   ,
         nRevenue_out   , nProductionStream_out,
         nP_out   , nQ_out   ,
         nActualP_target, nActualQ_target, nActualQ_target_devidedBy10,
         nRevenue_target, nProductionStream_target,
         nP_target, nQ_target;

  // CT variables
  float correction, correction1, correction2,
        actualP_target,
        actualQ_target,
        revenue_target,          revenue0,    revenueEO_target,
        productionStream_target, actualProductionStream,
        productionStreamEO_target, productionStream_out,

        myP, revenue_out, p_target,
        myQ, q_target;
// +++++++ end

}

  // the following methods are strictly related to the meaning the problem
  // data to which we are applying our neural network have

  // so, for each application, we have to modify them if we want to display
  // agent data or operate with them in a CT way

// +++++++ start
- (float)getRevenue0;
         // Revenue0     is the first  input in the 'ct-hayek' application
- (float)getProductionStream0;
    // ProductionStream0 is the second input in the 'ct-hayek' application
- (float)getP0;
         // P0           is the third  input in the 'ct-hayek' application
- (float)getQ0;
         // Q0           is the fourth input in the 'ct-hayek' application

- (float)getActualP_out;
         // ActualP_out    is the first   output in the 'ct-hayek' application
- (float)getActualP_target;
         // ActualP_target is the first   target in the 'ct-hayek' application
- (float)getActualQ_out;                 
         // ActualQ_out    is the second  output in the 'ct-hayek' application
- (float)getActualQ_target;
         // ActualQ_target is the second  target in the 'ct-hayek' application
- (float)getActualQ_target_devidedBy10;
         // ActualQ_target is the second  target in the 'ct-hayek' application
- (float)getRevenue_out;                 
         // Revenue_out    is the third   output in the 'ct-hayek' application
- (float)getRevenue_target;
         // Revenue_target
         //                is the third   target in the 'ct-hayek' application
- (float)getProductionStream_out;                 
// ProductionStream_out    is the fourth  output in the 'ct-hayek' application
- (float)getProductionStream_target;
// ProductionStream_target
         //                is the fourth  target in the 'ct-hayek' application
- (float)getP_out;
         // P_out          is the fifht   output in the 'ct-hayek' application
- (float)getP_target;
         // P_target       is the fifth   target in the 'ct-hayek' application
- (float)getQ_out;
         // Q_out          is the sixth   output in the 'ct-hayek' application
- (float)getQ_target;
         // Q_target       is the sixth   target in the 'ct-hayek' application

  // tools to communicate values while building targets in CT

- setActualP_target_via_CT: (float) v;
- setActualQ_target_via_CT: (float) v;
// +++++++ end

  // the following methods override those of Interface.h, which
  // are left void in Interface.m

- initialize;

- setCT_Inputs;
- setCT_Targets;

@end
