// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

//TransFunc.m                                        
// this code is kept apart to facilitate the task of modifying or changing
// the transformation function of the neural network; it must provide also
// the first derivative of the function

// always to simplify changes, the k value in 'transform:' method is read
// from transf.setup file

#import "TransFunc.h"
#import <math.h>

@implementation TransFunc

- createEnd
{
   [super createEnd];

   k=1;
   [ObjectLoader load: self fromFileNamed: "transf.setup"];

   return self;
}

- (float) transform: (float) v
{
   return 1.0/(1.0 + exp(-k*v));
}

- (float) firstDerivativeAt: (float) v
{
   return [self transform: v]*(1.0-[self transform: v])*k;
}

@end
                                     
