// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// Interface.h

// This is the basis of each agent interface; the adaptation to each speficic
// agent type are contained exclusively in specific interface objects,
// which inherit from this one (as an example, in the basic code distribution,
// we have SpecificInterface.h and .m)

#import <objectbase/SwarmObject.h>
#import "Matrix.h"
#import "DataWarehouse.h"

#import "math.h"   // to be used - if necessary - to generate inputs and
                   // targets in CT scheme, so in a specific interface
		  
#import "random.h" // as above

#import "collections.h" // to use lists and indexes - if necessary - in
                        // the specific interface objects inheriting
                        // from this one

@interface Interface: SwarmObject
{
  int number, patternNumberInVerificationSet, inputNodeNumber;
  Matrix * outputVerificationMatrix, * targetVerificationMatrix, 
         * dataVerificationMatrix, * dataTrainingMatrix,
         * minmax;
  DataWarehouse * myAgentDataWarehouse;

  int useEO_EP;

}

- createEnd;

- setDataWarehouse: dw;
- setUseEO_EP: (int) eo;
- setAgentNumber: (int) n;
- (int) getAgentNumber;

- initialize;
- setCT_Inputs;
- setCT_Targets;

@end
