// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// RuleMaker.h 

#import <objectbase/SwarmObject.h>
#import "Matrix.h"
#import "MatrixMult.h"
#import "VectorTransFunc.h"
#import "DataWarehouse.h"

@interface RuleMaker: SwarmObject
{
   DataWarehouse * agentDataWarehouse;
   Matrix * dataTrainingMatrix, * minmax, * outputTrainingMatrix,
          * targetTrainingMatrix,
       * wih, * dwih, * who, * dwho,
       * inputLayer, * hiddenLayer, * outputLayer, * deltaOut,
       * hiddenLayerTransFuncDerivatives, * outputLayerTransFuncDerivatives;
   int     inputNodeNumber, inputNodeNumber1,
           hiddenNodeNumber, hiddenNodeNumber1,
           outputNodeNumber, patternNumberInTrainingSet,
           epochNumberInEachTrainingCycle,
           longTermLearningInCT_OnlyWithCompleteTrainingSet,
           useOutputsAsTargetsInCT_RelearningScheme;
   float eps, alpha, backPropagationError, proportionalError;
   int * p, usingRandomOrderInLearning;
   MatrixMult * matrixMult;
   VectorTransFunc * vectorTransFunc;

}

- createEnd;
- setMatrixMult: mM;
- setVectorTransFunc: vtf;
- adaptRulesToInputOutputValuesInDataWarehouse: agentDW;

-(float) getBackPropagationErrorInTrainingSet;
-(float) getProportionalErrorInTrainingSet;


@end
